/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry;

import com.github.weisj.jsvg.attributes.value.LengthValue;
import com.github.weisj.jsvg.geometry.SVGShape;
import com.github.weisj.jsvg.renderer.MeasureContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public final class SVGCircle
implements SVGShape {
    @NotNull
    private final Ellipse2D.Float circle = new Ellipse2D.Float();
    @NotNull
    private final LengthValue cx;
    @NotNull
    private final LengthValue cy;
    @NotNull
    private final LengthValue r;

    public SVGCircle(@NotNull LengthValue cx4, @NotNull LengthValue cy4, @NotNull LengthValue r15) {
        this.cx = cx4;
        this.cy = cy4;
        this.r = r15;
    }

    private void validateShape(@NotNull MeasureContext measureContext) {
        float x15 = this.cx.resolve(measureContext);
        float y15 = this.cy.resolve(measureContext);
        float rr4 = this.r.resolve(measureContext);
        this.circle.setFrame(x15 - rr4, y15 - rr4, 2.0f * rr4, 2.0f * rr4);
    }

    @Override
    @NotNull
    public Shape shape(@NotNull RenderContext context, boolean validate) {
        if (validate) {
            this.validateShape(context.measureContext());
        }
        return this.circle;
    }

    @Override
    @NotNull
    public Rectangle2D bounds(@NotNull RenderContext context, boolean validate) {
        if (validate) {
            this.validateShape(context.measureContext());
        }
        return this.circle.getBounds2D();
    }

    @Override
    public double pathLength(@NotNull RenderContext context) {
        return SVGCircle.circumference(this.r.resolve(context.measureContext()));
    }

    @Override
    public boolean isClosed(@NotNull RenderContext context) {
        return true;
    }

    static double circumference(double radius) {
        return Math.PI * 2 * radius;
    }
}

