/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class JavaCompatibility2 {
    private static boolean getUIMethodInitialized;
    private static MethodHandle getUIMethod;

    public static ComponentUI getUI(JComponent c15) {
        try {
            if (SystemInfo.isJava_9_orLater) {
                if (!getUIMethodInitialized) {
                    getUIMethodInitialized = true;
                    try {
                        MethodType mt4 = MethodType.methodType(ComponentUI.class, new Class[0]);
                        getUIMethod = MethodHandles.publicLookup().findVirtual(JComponent.class, "getUI", mt4);
                    }
                    catch (Exception ex4) {
                        LoggingFacade.INSTANCE.logSevere(null, ex4);
                    }
                }
                if (getUIMethod != null) {
                    return getUIMethod.invoke(c15);
                }
            }
            if (c15 instanceof JPanel) {
                return ((JPanel)c15).getUI();
            }
            if (c15 instanceof JList) {
                return ((JList)c15).getUI();
            }
            if (c15 instanceof JTable) {
                return ((JTable)c15).getUI();
            }
            if (c15 instanceof JTree) {
                return ((JTree)c15).getUI();
            }
            if (c15 instanceof JTextComponent) {
                return ((JTextComponent)c15).getUI();
            }
            Method m15 = c15.getClass().getMethod("getUI", new Class[0]);
            return (ComponentUI)m15.invoke((Object)c15, new Object[0]);
        }
        catch (Throwable ex5) {
            return null;
        }
    }

    public static File[] getChooserShortcutPanelFiles(FileSystemView fsv) {
        try {
            if (SystemInfo.isJava_12_orLater) {
                Method m15 = fsv.getClass().getMethod("getChooserShortcutPanelFiles", new Class[0]);
                File[] files = (File[])m15.invoke((Object)fsv, new Object[0]);
                if (files.length == 1 && files[0].equals(new File(System.getProperty("user.home")))) {
                    files = new File[]{};
                }
                return files;
            }
            if (SystemInfo.isWindows) {
                Class<?> cls = Class.forName("sun.awt.shell.ShellFolder");
                Method m16 = cls.getMethod("get", String.class);
                return (File[])m16.invoke(null, "fileChooserShortcutPanelFolders");
            }
        }
        catch (IllegalAccessException cls) {
        }
        catch (Exception ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
        return new File[0];
    }

    public static File[] getChooserComboBoxFiles(FileSystemView fsv) {
        try {
            if (SystemInfo.isJava_9_orLater) {
                Method m15 = fsv.getClass().getMethod("getChooserComboBoxFiles", new Class[0]);
                return (File[])m15.invoke((Object)fsv, new Object[0]);
            }
            Class<?> cls = Class.forName("sun.awt.shell.ShellFolder");
            Method m16 = cls.getMethod("get", String.class);
            return (File[])m16.invoke(null, "fileChooserComboBoxFolders");
        }
        catch (IllegalAccessException cls) {
        }
        catch (Exception ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
        return new File[0];
    }
}

