/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatListUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.function.Function;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ListUI;

public class FlatListCellBorder
extends FlatLineBorder {
    protected boolean showCellFocusIndicator = UIManager.getBoolean("List.showCellFocusIndicator");
    private Component c;

    protected FlatListCellBorder() {
        super(UIManager.getInsets("List.cellMargins"), UIManager.getColor("List.cellFocusColor"));
    }

    @Override
    public Insets getBorderInsets(Component c15, Insets insets) {
        Insets m15 = FlatListCellBorder.getStyleFromListUI(c15, ui4 -> ui4.cellMargins);
        if (m15 != null) {
            return FlatListCellBorder.scaleInsets(c15, insets, m15.top, m15.left, m15.bottom, m15.right);
        }
        return super.getBorderInsets(c15, insets);
    }

    @Override
    public Color getLineColor() {
        Color color;
        if (this.c != null && (color = FlatListCellBorder.getStyleFromListUI(this.c, ui4 -> ui4.cellFocusColor)) != null) {
            return color;
        }
        return super.getLineColor();
    }

    @Override
    public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
        this.c = c15;
        super.paintBorder(c15, g15, x15, y15, width, height);
        this.c = null;
    }

    static <T> T getStyleFromListUI(Component c15, Function<FlatListUI, T> f15) {
        ListUI ui4;
        JList list2 = (JList)SwingUtilities.getAncestorOfClass(JList.class, c15);
        if (list2 != null && (ui4 = list2.getUI()) instanceof FlatListUI) {
            return f15.apply((FlatListUI)ui4);
        }
        return null;
    }

    public static class Selected
    extends FlatListCellBorder {
        @Override
        public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
            boolean showCellFocusIndicator;
            Boolean b15 = Selected.getStyleFromListUI(c15, ui4 -> ui4.showCellFocusIndicator);
            boolean bl4 = showCellFocusIndicator = b15 != null ? b15 : this.showCellFocusIndicator;
            if (!showCellFocusIndicator) {
                return;
            }
            JList list2 = (JList)SwingUtilities.getAncestorOfClass(JList.class, c15);
            if (list2 != null && list2.getMinSelectionIndex() == list2.getMaxSelectionIndex()) {
                return;
            }
            super.paintBorder(c15, g15, x15, y15, width, height);
        }
    }

    public static class Focused
    extends FlatListCellBorder {
    }

    public static class Default
    extends FlatListCellBorder {
        @Override
        public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
        }
    }
}

