/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopPaneUI;

public class FlatDesktopPaneUI
extends BasicDesktopPaneUI {
    private LayoutDockListener layoutDockListener;
    private boolean layoutDockPending;

    public static ComponentUI createUI(JComponent c15) {
        return new FlatDesktopPaneUI();
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        this.layoutDockLaterOnce();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.layoutDockListener = new LayoutDockListener();
        this.desktop.addContainerListener(this.layoutDockListener);
        this.desktop.addComponentListener(this.layoutDockListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.desktop.removeContainerListener(this.layoutDockListener);
        this.desktop.removeComponentListener(this.layoutDockListener);
        this.layoutDockListener = null;
    }

    private void layoutDockLaterOnce() {
        if (this.layoutDockPending) {
            return;
        }
        this.layoutDockPending = true;
        EventQueue.invokeLater(() -> {
            this.layoutDockPending = false;
            if (this.desktop != null) {
                this.layoutDock();
            }
        });
    }

    protected void layoutDock() {
        Dimension desktopSize = this.desktop.getSize();
        int x15 = 0;
        int y15 = desktopSize.height;
        int rowHeight = 0;
        for (Component c15 : this.desktop.getComponents()) {
            if (!(c15 instanceof JInternalFrame.JDesktopIcon)) continue;
            JInternalFrame.JDesktopIcon icon = (JInternalFrame.JDesktopIcon)c15;
            Dimension iconSize = icon.getPreferredSize();
            if (x15 + iconSize.width > desktopSize.width) {
                x15 = 0;
                y15 -= rowHeight;
                rowHeight = 0;
            }
            icon.setLocation(x15, y15 - iconSize.height);
            x15 += iconSize.width;
            rowHeight = Math.max(iconSize.height, rowHeight);
        }
    }

    private class LayoutDockListener
    extends ComponentAdapter
    implements ContainerListener {
        private LayoutDockListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e15) {
            FlatDesktopPaneUI.this.layoutDockLaterOnce();
        }

        @Override
        public void componentRemoved(ContainerEvent e15) {
            FlatDesktopPaneUI.this.layoutDockLaterOnce();
        }

        @Override
        public void componentResized(ComponentEvent e15) {
            FlatDesktopPaneUI.this.layoutDockLaterOnce();
        }
    }
}

