/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.smali;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.writer.builder.DexBuilder;
import com.android.tools.smali.dexlib2.writer.io.FileDataStore;
import com.android.tools.smali.smali.SmaliOptions;
import com.android.tools.smali.smali.smaliFlexLexer;
import com.android.tools.smali.smali.smaliParser;
import com.android.tools.smali.smali.smaliTreeWalker;
import com.android.tools.smali.util.StringUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;

public class Smali {
    public static boolean assemble(SmaliOptions options, String ... input) throws IOException {
        return Smali.assemble(options, Arrays.asList(input));
    }

    public static boolean assemble(final SmaliOptions options, List<String> input) throws IOException {
        TreeSet<File> filesToProcessSet = new TreeSet<File>();
        for (String fileToProcess : input) {
            File argFile = new File(fileToProcess);
            if (!argFile.exists()) {
                throw new IllegalArgumentException("Cannot find file or directory \"" + fileToProcess + "\"");
            }
            if (argFile.isDirectory()) {
                Smali.getSmaliFilesInDir(argFile, filesToProcessSet);
                continue;
            }
            if (!argFile.isFile()) continue;
            filesToProcessSet.add(argFile);
        }
        boolean errors = false;
        final DexBuilder dexBuilder = new DexBuilder(Opcodes.forApi(options.apiLevel));
        ExecutorService executor = Executors.newFixedThreadPool(options.jobs);
        ArrayList<Future<Boolean>> tasks = Lists.newArrayList();
        for (final File file2 : filesToProcessSet) {
            tasks.add(executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Smali.assembleSmaliFile(file2, dexBuilder, options);
                }
            }));
        }
        block6: for (Future future : tasks) {
            while (true) {
                try {
                    try {
                        if (((Boolean)future.get()).booleanValue()) continue block6;
                        errors = true;
                        continue block6;
                    }
                    catch (ExecutionException ex4) {
                        throw new RuntimeException(ex4);
                    }
                }
                catch (InterruptedException ex5) {
                    continue;
                }
                break;
            }
        }
        executor.shutdown();
        if (errors) {
            return false;
        }
        dexBuilder.writeTo(new FileDataStore(new File(options.outputDexFile)));
        return true;
    }

    public static boolean printTokens(SmaliOptions options, List<String> input) throws IOException {
        TreeSet<File> filesToProcessSet = new TreeSet<File>();
        for (String fileToProcess : input) {
            File argFile = new File(fileToProcess);
            if (!argFile.exists()) {
                throw new IllegalArgumentException("Cannot find file or directory \"" + fileToProcess + "\"");
            }
            if (argFile.isDirectory()) {
                Smali.getSmaliFilesInDir(argFile, filesToProcessSet);
                continue;
            }
            if (!argFile.isFile()) continue;
            filesToProcessSet.add(argFile);
        }
        boolean errors = false;
        for (File file2 : filesToProcessSet) {
            try {
                errors |= !Smali.printTokensForSingleFile(file2, options);
            }
            catch (Exception ex4) {
                throw new RuntimeException(ex4);
            }
        }
        return !errors;
    }

    private static void getSmaliFilesInDir(@Nonnull File dir, @Nonnull Set<File> smaliFiles) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file2 : files) {
                if (file2.isDirectory()) {
                    Smali.getSmaliFilesInDir(file2, smaliFiles);
                    continue;
                }
                if (!file2.getName().endsWith(".smali")) continue;
                smaliFiles.add(file2);
            }
        }
    }

    private static boolean assembleSmaliFile(File smaliFile, DexBuilder dexBuilder, SmaliOptions options) throws Exception {
        try (FileInputStream fis = new FileInputStream(smaliFile);){
            InputStreamReader reader = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
            smaliFlexLexer lexer = new smaliFlexLexer(reader, options.apiLevel);
            lexer.setSourceFile(smaliFile);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            if (options.printTokens) {
                tokens.getTokens();
                for (int i15 = 0; i15 < tokens.size(); ++i15) {
                    Token token = tokens.get(i15);
                    if (token.getChannel() == 99) continue;
                    String tokenName = token.getType() == -1 ? "EOF" : smaliParser.tokenNames[token.getType()];
                    System.out.println(tokenName + ": " + token.getText());
                }
                System.out.flush();
            }
            smaliParser parser = new smaliParser(tokens);
            parser.setVerboseErrors(options.verboseErrors);
            parser.setAllowOdex(options.allowOdexOpcodes);
            parser.setApiLevel(options.apiLevel);
            smaliParser.smali_file_return result = parser.smali_file();
            if (parser.getNumberOfSyntaxErrors() > 0 || lexer.getNumberOfSyntaxErrors() > 0) {
                boolean tokenName = false;
                return tokenName;
            }
            CommonTree t15 = result.getTree();
            CommonTreeNodeStream treeStream = new CommonTreeNodeStream(t15);
            treeStream.setTokenStream(tokens);
            if (options.printTokens) {
                System.out.println(t15.toStringTree());
            }
            smaliTreeWalker dexGen = new smaliTreeWalker(treeStream);
            dexGen.setApiLevel(options.apiLevel);
            dexGen.setVerboseErrors(options.verboseErrors);
            dexGen.setDexBuilder(dexBuilder);
            dexGen.smali_file();
            boolean bl4 = dexGen.getNumberOfSyntaxErrors() == 0;
            return bl4;
        }
    }

    private static boolean printTokensForSingleFile(File smaliFile, SmaliOptions options) throws Exception {
        try (FileInputStream fis = new FileInputStream(smaliFile);){
            InputStreamReader reader = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
            smaliFlexLexer lexer = new smaliFlexLexer(reader, options.apiLevel);
            lexer.setSourceFile(smaliFile);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            tokens.fill();
            for (int i15 = 0; i15 < tokens.size(); ++i15) {
                Token token = tokens.get(i15);
                if (token.getChannel() == 99) continue;
                String tokenName = token.getType() == -1 ? "EOF" : smaliParser.tokenNames[token.getType()];
                System.out.println(tokenName + "(\"" + StringUtils.escapeString(token.getText()) + "\")");
            }
            System.out.flush();
            boolean bl4 = lexer.getNumberOfSyntaxErrors() == 0;
            return bl4;
        }
    }
}

