/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.aapt.Resources;
import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.commands.DumpManagerUtils;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

final class DumpSdkBundleManager {
    private final PrintStream printStream;
    private final Path bundlePath;

    DumpSdkBundleManager(OutputStream outputStream, Path bundlePath) {
        this.printStream = new PrintStream(outputStream);
        this.bundlePath = bundlePath;
    }

    void printManifest(Optional<String> xPathExpression) {
        ZipPath manifestPath = ZipPath.create(BundleModuleName.BASE_MODULE_NAME.getName()).resolve(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath());
        XmlProtoNode manifestProto = new XmlProtoNode(DumpManagerUtils.extractAndParseFromSdkBundle(this.bundlePath, manifestPath, Resources.XmlNode::parseFrom));
        DumpManagerUtils.printManifest(manifestProto, xPathExpression, this.printStream);
    }

    void printResources(Predicate<ResourceTableEntry> resourcePredicate, boolean printValues) {
        ImmutableList<Resources.ResourceTable> resourceTables;
        try (ZipFile zipFile = new ZipFile(this.bundlePath.toFile());){
            ZipEntry zipEntry = zipFile.getEntry("modules.resm");
            resourceTables = ZipUtils.allFileEntriesPaths(new ZipInputStream(zipFile.getInputStream(zipEntry))).stream().filter(path -> path.endsWith(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath())).map(path -> DumpManagerUtils.extractAndParseFromSdkBundle(this.bundlePath, path, Resources.ResourceTable::parseFrom)).collect(ImmutableList.toImmutableList());
        }
        catch (IOException e15) {
            throw new UncheckedIOException("Error occurred when reading the bundle.", e15);
        }
        DumpManagerUtils.printResources(resourcePredicate, printValues, resourceTables, this.printStream);
    }

    void printBundleConfig() {
        SdkModulesConfigOuterClass.SdkModulesConfig bundleConfig = DumpManagerUtils.extractAndParseFromSdkBundle(this.bundlePath, ZipPath.create("SdkModulesConfig.pb"), SdkModulesConfigOuterClass.SdkModulesConfig::parseFrom);
        DumpManagerUtils.printBundleConfig(bundleConfig, this.printStream);
    }
}

