/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.InsnList;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.code.Rops;
import com.android.dx.ssa.BasicRegisterMapper;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.ssa.back.FirstFitLocalCombiningAllocator;
import com.android.dx.ssa.back.IdenticalBlockCombiner;
import com.android.dx.ssa.back.InterferenceGraph;
import com.android.dx.ssa.back.LivenessAnalyzer;
import com.android.dx.ssa.back.RegisterAllocator;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;

public class SsaToRop {
    private static final boolean DEBUG = false;
    private final SsaMethod ssaMeth;
    private final boolean minimizeRegisters;
    private final InterferenceGraph interference;

    public static RopMethod convertToRopMethod(SsaMethod ssaMeth, boolean minimizeRegisters) {
        return new SsaToRop(ssaMeth, minimizeRegisters).convert();
    }

    private SsaToRop(SsaMethod ssaMethod, boolean minimizeRegisters) {
        this.minimizeRegisters = minimizeRegisters;
        this.ssaMeth = ssaMethod;
        this.interference = LivenessAnalyzer.constructInterferenceGraph(ssaMethod);
    }

    private RopMethod convert() {
        FirstFitLocalCombiningAllocator allocator = new FirstFitLocalCombiningAllocator(this.ssaMeth, this.interference, this.minimizeRegisters);
        RegisterMapper mapper = ((RegisterAllocator)allocator).allocateRegisters();
        this.ssaMeth.setBackMode();
        this.ssaMeth.mapRegisters(mapper);
        this.removePhiFunctions();
        if (((RegisterAllocator)allocator).wantsParamsMovedHigh()) {
            this.moveParametersToHighRegisters();
        }
        this.removeEmptyGotos();
        RopMethod ropMethod = new RopMethod(this.convertBasicBlocks(), this.ssaMeth.blockIndexToRopLabel(this.ssaMeth.getEntryBlockIndex()));
        ropMethod = new IdenticalBlockCombiner(ropMethod).process();
        return ropMethod;
    }

    private void removeEmptyGotos() {
        final ArrayList<SsaBasicBlock> blocks = this.ssaMeth.getBlocks();
        this.ssaMeth.forEachBlockDepthFirst(false, new SsaBasicBlock.Visitor(){
            final /* synthetic */ SsaToRop this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visitBlock(SsaBasicBlock b15, SsaBasicBlock parent) {
                ArrayList<SsaInsn> insns = b15.getInsns();
                if (insns.size() == 1 && insns.get(0).getOpcode() == Rops.GOTO) {
                    BitSet preds = (BitSet)b15.getPredecessors().clone();
                    int i15 = preds.nextSetBit(0);
                    while (i15 >= 0) {
                        SsaBasicBlock pb5 = (SsaBasicBlock)blocks.get(i15);
                        pb5.replaceSuccessor(b15.getIndex(), b15.getPrimarySuccessorIndex());
                        i15 = preds.nextSetBit(i15 + 1);
                    }
                }
            }
        });
    }

    private void removePhiFunctions() {
        ArrayList<SsaBasicBlock> blocks = this.ssaMeth.getBlocks();
        for (SsaBasicBlock block : blocks) {
            block.forEachPhiInsn(new PhiVisitor(blocks));
            block.removeAllPhiInsns();
        }
        for (SsaBasicBlock block : blocks) {
            block.scheduleMovesFromPhis();
        }
    }

    private void moveParametersToHighRegisters() {
        int paramWidth = this.ssaMeth.getParamWidth();
        BasicRegisterMapper mapper = new BasicRegisterMapper(this.ssaMeth.getRegCount());
        int regCount = this.ssaMeth.getRegCount();
        for (int i15 = 0; i15 < regCount; ++i15) {
            if (i15 < paramWidth) {
                mapper.addMapping(i15, regCount - paramWidth + i15, 1);
                continue;
            }
            mapper.addMapping(i15, i15 - paramWidth, 1);
        }
        this.ssaMeth.mapRegisters(mapper);
    }

    private BasicBlockList convertBasicBlocks() {
        ArrayList<SsaBasicBlock> blocks = this.ssaMeth.getBlocks();
        SsaBasicBlock exitBlock = this.ssaMeth.getExitBlock();
        BitSet reachable = this.ssaMeth.computeReachability();
        int ropBlockCount = reachable.cardinality();
        if (exitBlock != null && reachable.get(exitBlock.getIndex())) {
            --ropBlockCount;
        }
        BasicBlockList result = new BasicBlockList(ropBlockCount);
        int ropBlockIndex = 0;
        for (SsaBasicBlock b15 : blocks) {
            if (!reachable.get(b15.getIndex()) || b15 == exitBlock) continue;
            result.set(ropBlockIndex++, this.convertBasicBlock(b15));
        }
        if (exitBlock != null && !exitBlock.getInsns().isEmpty()) {
            throw new RuntimeException("Exit block must have no insns when leaving SSA form");
        }
        return result;
    }

    private void verifyValidExitPredecessor(SsaBasicBlock b15) {
        ArrayList<SsaInsn> insns = b15.getInsns();
        SsaInsn lastInsn = insns.get(insns.size() - 1);
        Rop opcode = lastInsn.getOpcode();
        if (opcode.getBranchingness() != 2 && opcode != Rops.THROW) {
            throw new RuntimeException("Exit predecessor must end in valid exit statement.");
        }
    }

    private BasicBlock convertBasicBlock(SsaBasicBlock block) {
        int exitRopLabel;
        IntList successorList = block.getRopLabelSuccessorList();
        int primarySuccessorLabel = block.getPrimarySuccessorRopLabel();
        SsaBasicBlock exitBlock = this.ssaMeth.getExitBlock();
        int n15 = exitRopLabel = exitBlock == null ? -1 : exitBlock.getRopLabel();
        if (successorList.contains(exitRopLabel)) {
            if (successorList.size() > 1) {
                throw new RuntimeException("Exit predecessor must have no other successors" + Hex.u2(block.getRopLabel()));
            }
            successorList = IntList.EMPTY;
            primarySuccessorLabel = -1;
            this.verifyValidExitPredecessor(block);
        }
        successorList.setImmutable();
        BasicBlock result = new BasicBlock(block.getRopLabel(), this.convertInsns(block.getInsns()), successorList, primarySuccessorLabel);
        return result;
    }

    private InsnList convertInsns(ArrayList<SsaInsn> ssaInsns) {
        int insnCount = ssaInsns.size();
        InsnList result = new InsnList(insnCount);
        for (int i15 = 0; i15 < insnCount; ++i15) {
            result.set(i15, ssaInsns.get(i15).toRopInsn());
        }
        result.setImmutable();
        return result;
    }

    public int[] getRegistersByFrequency() {
        int regCount = this.ssaMeth.getRegCount();
        Integer[] ret = new Integer[regCount];
        for (int i15 = 0; i15 < regCount; ++i15) {
            ret[i15] = i15;
        }
        Arrays.sort(ret, new Comparator<Integer>(){

            @Override
            public int compare(Integer o15, Integer o25) {
                return SsaToRop.this.ssaMeth.getUseListForRegister(o25).size() - SsaToRop.this.ssaMeth.getUseListForRegister(o15).size();
            }
        });
        int[] result = new int[regCount];
        for (int i16 = 0; i16 < regCount; ++i16) {
            result[i16] = ret[i16];
        }
        return result;
    }

    private static class PhiVisitor
    implements PhiInsn.Visitor {
        private final ArrayList<SsaBasicBlock> blocks;

        public PhiVisitor(ArrayList<SsaBasicBlock> blocks) {
            this.blocks = blocks;
        }

        @Override
        public void visitPhiInsn(PhiInsn insn) {
            RegisterSpecList sources = insn.getSources();
            RegisterSpec result = insn.getResult();
            int sz4 = sources.size();
            for (int i15 = 0; i15 < sz4; ++i15) {
                RegisterSpec source = sources.get(i15);
                SsaBasicBlock predBlock = this.blocks.get(insn.predBlockIndexForSourcesIndex(i15));
                predBlock.addMoveToEnd(result, source);
            }
        }
    }
}

