/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.cf.code.Merger;
import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import java.util.BitSet;
import java.util.List;

public class PhiTypeResolver {
    SsaMethod ssaMeth;
    private final BitSet worklist;

    public static void process(SsaMethod ssaMeth) {
        new PhiTypeResolver(ssaMeth).run();
    }

    private PhiTypeResolver(SsaMethod ssaMeth) {
        this.ssaMeth = ssaMeth;
        this.worklist = new BitSet(ssaMeth.getRegCount());
    }

    private void run() {
        SsaInsn definsn;
        int reg;
        int regCount = this.ssaMeth.getRegCount();
        for (reg = 0; reg < regCount; ++reg) {
            definsn = this.ssaMeth.getDefinitionForRegister(reg);
            if (definsn == null || definsn.getResult().getBasicType() != 0) continue;
            this.worklist.set(reg);
        }
        while (0 <= (reg = this.worklist.nextSetBit(0))) {
            this.worklist.clear(reg);
            definsn = (PhiInsn)this.ssaMeth.getDefinitionForRegister(reg);
            if (!this.resolveResultType((PhiInsn)definsn)) continue;
            List<SsaInsn> useList = this.ssaMeth.getUseListForRegister(reg);
            int sz4 = useList.size();
            for (int i15 = 0; i15 < sz4; ++i15) {
                SsaInsn useInsn = useList.get(i15);
                RegisterSpec resultReg = useInsn.getResult();
                if (resultReg == null || !(useInsn instanceof PhiInsn)) continue;
                this.worklist.set(resultReg.getReg());
            }
        }
    }

    private static boolean equalsHandlesNulls(LocalItem a15, LocalItem b15) {
        return a15 == b15 || a15 != null && a15.equals(b15);
    }

    boolean resolveResultType(PhiInsn insn) {
        insn.updateSourcesToDefinitions(this.ssaMeth);
        RegisterSpecList sources = insn.getSources();
        RegisterSpec first = null;
        int firstIndex = -1;
        int szSources = sources.size();
        for (int i15 = 0; i15 < szSources; ++i15) {
            RegisterSpec rs4 = sources.get(i15);
            if (rs4.getBasicType() == 0) continue;
            first = rs4;
            firstIndex = i15;
        }
        if (first == null) {
            return false;
        }
        LocalItem firstLocal = first.getLocalItem();
        TypeBearer mergedType = first.getType();
        boolean sameLocals = true;
        for (int i16 = 0; i16 < szSources; ++i16) {
            RegisterSpec rs5;
            if (i16 == firstIndex || (rs5 = sources.get(i16)).getBasicType() == 0) continue;
            sameLocals = sameLocals && PhiTypeResolver.equalsHandlesNulls(firstLocal, rs5.getLocalItem());
            mergedType = Merger.mergeType(mergedType, rs5.getType());
        }
        if (mergedType == null) {
            StringBuilder sb5 = new StringBuilder();
            for (int i17 = 0; i17 < szSources; ++i17) {
                sb5.append(sources.get(i17).toString());
                sb5.append(' ');
            }
            throw new RuntimeException("Couldn't map types in phi insn:" + sb5);
        }
        Type newResultType = mergedType;
        LocalItem newLocal = sameLocals ? firstLocal : null;
        RegisterSpec result = insn.getResult();
        if (result.getTypeBearer() == newResultType && PhiTypeResolver.equalsHandlesNulls(newLocal, result.getLocalItem())) {
            return false;
        }
        insn.changeResultType(newResultType, newLocal);
        return true;
    }
}

