/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.ssa.DomFront;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaMethod;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;

public final class Dominators {
    private final boolean postdom;
    private final SsaMethod meth;
    private final ArrayList<SsaBasicBlock> blocks;
    private final DFSInfo[] info;
    private final ArrayList<SsaBasicBlock> vertex;
    private final DomFront.DomInfo[] domInfos;

    private Dominators(SsaMethod meth, DomFront.DomInfo[] domInfos, boolean postdom) {
        this.meth = meth;
        this.domInfos = domInfos;
        this.postdom = postdom;
        this.blocks = meth.getBlocks();
        this.info = new DFSInfo[this.blocks.size() + 2];
        this.vertex = new ArrayList();
    }

    public static Dominators make(SsaMethod meth, DomFront.DomInfo[] domInfos, boolean postdom) {
        Dominators result = new Dominators(meth, domInfos, postdom);
        result.run();
        return result;
    }

    private BitSet getSuccs(SsaBasicBlock block) {
        if (this.postdom) {
            return block.getPredecessors();
        }
        return block.getSuccessors();
    }

    private BitSet getPreds(SsaBasicBlock block) {
        if (this.postdom) {
            return block.getSuccessors();
        }
        return block.getPredecessors();
    }

    private void compress(SsaBasicBlock in4) {
        DFSInfo bbInfo = this.info[in4.getIndex()];
        DFSInfo ancestorbbInfo = this.info[bbInfo.ancestor.getIndex()];
        if (ancestorbbInfo.ancestor != null) {
            ArrayList<SsaBasicBlock> worklist = new ArrayList<SsaBasicBlock>();
            HashSet<SsaBasicBlock> visited = new HashSet<SsaBasicBlock>();
            worklist.add(in4);
            while (!worklist.isEmpty()) {
                int wsize = worklist.size();
                SsaBasicBlock v15 = (SsaBasicBlock)worklist.get(wsize - 1);
                DFSInfo vbbInfo = this.info[v15.getIndex()];
                SsaBasicBlock vAncestor = vbbInfo.ancestor;
                DFSInfo vabbInfo = this.info[vAncestor.getIndex()];
                if (visited.add(vAncestor) && vabbInfo.ancestor != null) {
                    worklist.add(vAncestor);
                    continue;
                }
                worklist.remove(wsize - 1);
                if (vabbInfo.ancestor == null) continue;
                SsaBasicBlock vAncestorRep = vabbInfo.rep;
                SsaBasicBlock vRep = vbbInfo.rep;
                if (this.info[vAncestorRep.getIndex()].semidom < this.info[vRep.getIndex()].semidom) {
                    vbbInfo.rep = vAncestorRep;
                }
                vbbInfo.ancestor = vabbInfo.ancestor;
            }
        }
    }

    private SsaBasicBlock eval(SsaBasicBlock v15) {
        DFSInfo bbInfo = this.info[v15.getIndex()];
        if (bbInfo.ancestor == null) {
            return v15;
        }
        this.compress(v15);
        return bbInfo.rep;
    }

    private void run() {
        SsaBasicBlock w15;
        int dfsMax;
        int i15;
        SsaBasicBlock root;
        SsaBasicBlock ssaBasicBlock = root = this.postdom ? this.meth.getExitBlock() : this.meth.getEntryBlock();
        if (root != null) {
            this.vertex.add(root);
            this.domInfos[root.getIndex()].idom = root.getIndex();
        }
        DfsWalker walker = new DfsWalker();
        this.meth.forEachBlockDepthFirst(this.postdom, walker);
        for (i15 = dfsMax = this.vertex.size() - 1; i15 >= 2; --i15) {
            w15 = this.vertex.get(i15);
            DFSInfo wInfo = this.info[w15.getIndex()];
            BitSet preds = this.getPreds(w15);
            int j15 = preds.nextSetBit(0);
            while (j15 >= 0) {
                int predSemidom;
                SsaBasicBlock predBlock = this.blocks.get(j15);
                DFSInfo predInfo = this.info[predBlock.getIndex()];
                if (predInfo != null && (predSemidom = this.info[this.eval((SsaBasicBlock)predBlock).getIndex()].semidom) < wInfo.semidom) {
                    wInfo.semidom = predSemidom;
                }
                j15 = preds.nextSetBit(j15 + 1);
            }
            this.info[this.vertex.get((int)wInfo.semidom).getIndex()].bucket.add(w15);
            wInfo.ancestor = wInfo.parent;
            ArrayList<SsaBasicBlock> wParentBucket = this.info[wInfo.parent.getIndex()].bucket;
            while (!wParentBucket.isEmpty()) {
                int lastItem = wParentBucket.size() - 1;
                SsaBasicBlock last = wParentBucket.remove(lastItem);
                SsaBasicBlock U11 = this.eval(last);
                if (this.info[U11.getIndex()].semidom < this.info[last.getIndex()].semidom) {
                    this.domInfos[last.getIndex()].idom = U11.getIndex();
                    continue;
                }
                this.domInfos[last.getIndex()].idom = wInfo.parent.getIndex();
            }
        }
        for (i15 = 2; i15 <= dfsMax; ++i15) {
            w15 = this.vertex.get(i15);
            if (this.domInfos[w15.getIndex()].idom == this.vertex.get(this.info[w15.getIndex()].semidom).getIndex()) continue;
            this.domInfos[w15.getIndex()].idom = this.domInfos[this.domInfos[w15.getIndex()].idom].idom;
        }
    }

    private static final class DFSInfo {
        public int semidom;
        public SsaBasicBlock parent;
        public SsaBasicBlock rep;
        public SsaBasicBlock ancestor;
        public ArrayList<SsaBasicBlock> bucket = new ArrayList();
    }

    private class DfsWalker
    implements SsaBasicBlock.Visitor {
        private int dfsNum = 0;

        private DfsWalker() {
        }

        @Override
        public void visitBlock(SsaBasicBlock v15, SsaBasicBlock parent) {
            DFSInfo bbInfo = new DFSInfo();
            bbInfo.semidom = ++this.dfsNum;
            bbInfo.rep = v15;
            bbInfo.parent = parent;
            Dominators.this.vertex.add(v15);
            ((Dominators)Dominators.this).info[v15.getIndex()] = bbInfo;
        }
    }
}

