/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Node;
import ch.qos.logback.core.subst.Token;
import java.util.List;

public class Parser {
    public static final String EXPECTING_DATA_AFTER_LEFT_ACCOLADE = "Expecting at least a literal between left accolade and ':-'";
    final List<Token> tokenList;
    int pointer = 0;

    public Parser(List<Token> tokenList) {
        this.tokenList = tokenList;
    }

    public Node parse() throws ScanException {
        if (this.tokenList == null || this.tokenList.isEmpty()) {
            return null;
        }
        return this.E();
    }

    private Node E() throws ScanException {
        Node t15 = this.T();
        if (t15 == null) {
            return null;
        }
        Node eOpt = this.Eopt();
        if (eOpt != null) {
            t15.append(eOpt);
        }
        return t15;
    }

    private Node Eopt() throws ScanException {
        Token next = this.peekAtCurentToken();
        if (next == null) {
            return null;
        }
        return this.E();
    }

    private Node T() throws ScanException {
        Token t15 = this.peekAtCurentToken();
        if (t15 == null) {
            return null;
        }
        switch (t15.type) {
            case LITERAL: {
                this.advanceTokenPointer();
                return this.makeNewLiteralNode(t15.payload);
            }
            case CURLY_LEFT: {
                this.advanceTokenPointer();
                Node innerNode = this.C();
                Token right = this.peekAtCurentToken();
                this.expectCurlyRight(right);
                this.advanceTokenPointer();
                Node curlyLeft = this.makeNewLiteralNode(CoreConstants.LEFT_ACCOLADE);
                curlyLeft.append(innerNode);
                curlyLeft.append(this.makeNewLiteralNode(CoreConstants.RIGHT_ACCOLADE));
                return curlyLeft;
            }
            case START: {
                this.advanceTokenPointer();
                Node v15 = this.V();
                Token w15 = this.peekAtCurentToken();
                this.expectCurlyRight(w15);
                this.advanceTokenPointer();
                return v15;
            }
        }
        return null;
    }

    private Node makeNewLiteralNode(String s15) {
        return new Node(Node.Type.LITERAL, s15);
    }

    private Node V() throws ScanException {
        Node e15 = this.E();
        Node variable = new Node(Node.Type.VARIABLE, e15);
        Token t15 = this.peekAtCurentToken();
        if (this.isDefaultToken(t15)) {
            this.advanceTokenPointer();
            Node def = this.Eopt();
            variable.defaultPart = def != null ? def : this.makeNewLiteralNode("");
        }
        return variable;
    }

    private Node C() throws ScanException {
        Node e05 = this.E();
        Token t15 = this.peekAtCurentToken();
        if (this.isDefaultToken(t15)) {
            this.advanceTokenPointer();
            Node literal = this.makeNewLiteralNode(":-");
            if (e05 == null) {
                throw new ScanException(EXPECTING_DATA_AFTER_LEFT_ACCOLADE);
            }
            e05.append(literal);
            Node e15 = this.E();
            e05.append(e15);
        }
        return e05;
    }

    private boolean isDefaultToken(Token t15) {
        return t15 != null && t15.type == Token.Type.DEFAULT;
    }

    void advanceTokenPointer() {
        ++this.pointer;
    }

    void expectNotNull(Token t15, String expected) {
        if (t15 == null) {
            throw new IllegalArgumentException("All tokens consumed but was expecting \"" + expected + "\"");
        }
    }

    void expectCurlyRight(Token t15) throws ScanException {
        this.expectNotNull(t15, "}");
        if (t15.type != Token.Type.CURLY_RIGHT) {
            throw new ScanException("Expecting }");
        }
    }

    Token peekAtCurentToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer);
        }
        return null;
    }
}

