/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.encoder.JsonEscapeUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;

public class JsonEncoder
extends EncoderBase<ILoggingEvent> {
    static final boolean DO_NOT_ADD_QUOTE_KEY = false;
    static final boolean ADD_QUOTE_KEY = true;
    static int DEFAULT_SIZE = 1024;
    static int DEFAULT_SIZE_WITH_THROWABLE = DEFAULT_SIZE * 8;
    static byte[] EMPTY_BYTES = new byte[0];
    public static final String CONTEXT_ATTR_NAME = "context";
    public static final String NAME_ATTR_NAME = "name";
    public static final String BIRTHDATE_ATTR_NAME = "birthdate";
    public static final String CONTEXT_PROPERTIES_ATTR_NAME = "properties";
    public static final String TIMESTAMP_ATTR_NAME = "timestamp";
    public static final String NANOSECONDS_ATTR_NAME = "nanoseconds";
    public static final String SEQUENCE_NUMBER_ATTR_NAME = "sequenceNumber";
    public static final String LEVEL_ATTR_NAME = "level";
    public static final String MARKERS_ATTR_NAME = "markers";
    public static final String THREAD_NAME_ATTR_NAME = "threadName";
    public static final String MDC_ATTR_NAME = "mdc";
    public static final String LOGGER_ATTR_NAME = "loggerName";
    public static final String MESSAGE_ATTR_NAME = "message";
    public static final String FORMATTED_MESSAGE_ATTR_NAME = "formattedMessage";
    public static final String ARGUMENT_ARRAY_ATTR_NAME = "arguments";
    public static final String KEY_VALUE_PAIRS_ATTR_NAME = "kvpList";
    public static final String THROWABLE_ATTR_NAME = "throwable";
    private static final String CYCLIC_THROWABLE_ATTR_NAME = "cyclic";
    public static final String CAUSE_ATTR_NAME = "cause";
    public static final String SUPPRESSED_ATTR_NAME = "suppressed";
    public static final String COMMON_FRAMES_COUNT_ATTR_NAME = "commonFramesCount";
    public static final String CLASS_NAME_ATTR_NAME = "className";
    public static final String METHOD_NAME_ATTR_NAME = "methodName";
    private static final String FILE_NAME_ATTR_NAME = "fileName";
    private static final String LINE_NUMBER_ATTR_NAME = "lineNumber";
    public static final String STEP_ARRAY_NAME_ATTRIBUTE = "stepArray";
    protected static final char OPEN_OBJ = '{';
    protected static final char CLOSE_OBJ = '}';
    protected static final char OPEN_ARRAY = '[';
    protected static final char CLOSE_ARRAY = ']';
    protected static final char QUOTE = '\"';
    protected static final char SP = ' ';
    protected static final char ENTRY_SEPARATOR = ':';
    protected static final String COL_SP = ": ";
    protected static final String QUOTE_COL = "\":";
    protected static final char VALUE_SEPARATOR = ',';
    private boolean withSequenceNumber = true;
    private boolean withTimestamp = true;
    private boolean withNanoseconds = true;
    private boolean withLevel = true;
    private boolean withThreadName = true;
    private boolean withLoggerName = true;
    private boolean withContext = true;
    private boolean withMarkers = true;
    private boolean withMDC = true;
    private boolean withKVPList = true;
    private boolean withMessage = true;
    private boolean withArguments = true;
    private boolean withThrowable = true;
    private boolean withFormattedMessage = false;

    @Override
    public byte[] headerBytes() {
        return EMPTY_BYTES;
    }

    @Override
    public byte[] encode(ILoggingEvent event) {
        int initialCapacity = event.getThrowableProxy() == null ? DEFAULT_SIZE : DEFAULT_SIZE_WITH_THROWABLE;
        StringBuilder sb5 = new StringBuilder(initialCapacity);
        sb5.append('{');
        if (this.withSequenceNumber) {
            this.appenderMemberWithLongValue(sb5, SEQUENCE_NUMBER_ATTR_NAME, event.getSequenceNumber());
        }
        if (this.withTimestamp) {
            this.appendValueSeparator(sb5, this.withSequenceNumber);
            this.appenderMemberWithLongValue(sb5, TIMESTAMP_ATTR_NAME, event.getTimeStamp());
        }
        if (this.withNanoseconds) {
            this.appendValueSeparator(sb5, this.withSequenceNumber, this.withTimestamp);
            this.appenderMemberWithLongValue(sb5, NANOSECONDS_ATTR_NAME, event.getNanoseconds());
        }
        if (this.withLevel) {
            this.appendValueSeparator(sb5, this.withNanoseconds, this.withSequenceNumber, this.withTimestamp);
            String levelStr = event.getLevel() != null ? event.getLevel().levelStr : "null";
            this.appenderMember(sb5, LEVEL_ATTR_NAME, levelStr);
        }
        if (this.withThreadName) {
            this.appendValueSeparator(sb5, this.withLevel, this.withNanoseconds, this.withSequenceNumber, this.withTimestamp);
            this.appenderMember(sb5, THREAD_NAME_ATTR_NAME, this.jsonEscape(event.getThreadName()));
        }
        if (this.withLoggerName) {
            this.appendValueSeparator(sb5, this.withThreadName, this.withLevel, this.withNanoseconds, this.withSequenceNumber, this.withTimestamp);
            this.appenderMember(sb5, LOGGER_ATTR_NAME, event.getLoggerName());
        }
        if (this.withContext) {
            sb5.append(',');
            this.appendLoggerContext(sb5, event.getLoggerContextVO());
        }
        if (this.withMarkers) {
            this.appendMarkers(sb5, event);
        }
        if (this.withMDC) {
            this.appendMDC(sb5, event);
        }
        if (this.withKVPList) {
            this.appendKeyValuePairs(sb5, event);
        }
        if (this.withMessage) {
            sb5.append(',');
            this.appenderMember(sb5, MESSAGE_ATTR_NAME, this.jsonEscape(event.getMessage()));
        }
        if (this.withFormattedMessage) {
            sb5.append(',');
            this.appenderMember(sb5, FORMATTED_MESSAGE_ATTR_NAME, this.jsonEscape(event.getFormattedMessage()));
        }
        if (this.withArguments) {
            this.appendArgumentArray(sb5, event);
        }
        if (this.withThrowable) {
            this.appendThrowableProxy(sb5, THROWABLE_ATTR_NAME, event.getThrowableProxy());
        }
        this.appendCustomFields(sb5, event);
        sb5.append('}');
        sb5.append('\n');
        return sb5.toString().getBytes(CoreConstants.UTF_8_CHARSET);
    }

    protected void appendValueSeparator(StringBuilder sb5, boolean ... subsequentConditionals) {
        boolean enabled = false;
        for (boolean subsequent : subsequentConditionals) {
            if (!subsequent) continue;
            enabled = true;
            break;
        }
        if (enabled) {
            sb5.append(',');
        }
    }

    protected void appendLoggerContext(StringBuilder sb5, LoggerContextVO loggerContextVO) {
        sb5.append('\"').append(CONTEXT_ATTR_NAME).append(QUOTE_COL);
        if (loggerContextVO == null) {
            sb5.append("null");
            return;
        }
        sb5.append('{');
        this.appenderMember(sb5, NAME_ATTR_NAME, this.nullSafeStr(loggerContextVO.getName()));
        sb5.append(',');
        this.appenderMemberWithLongValue(sb5, BIRTHDATE_ATTR_NAME, loggerContextVO.getBirthTime());
        sb5.append(',');
        this.appendMap(sb5, CONTEXT_PROPERTIES_ATTR_NAME, loggerContextVO.getPropertyMap());
        sb5.append('}');
    }

    protected void appendMap(StringBuilder sb5, String attrName, Map<String, String> map) {
        sb5.append('\"').append(attrName).append(QUOTE_COL);
        if (map == null) {
            sb5.append("null");
            return;
        }
        sb5.append('{');
        boolean addComma = false;
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (addComma) {
                sb5.append(',');
            }
            addComma = true;
            this.appenderMember(sb5, this.jsonEscapedToString(entry.getKey()), this.jsonEscapedToString(entry.getValue()));
        }
        sb5.append('}');
    }

    protected void appendThrowableProxy(StringBuilder sb5, String attributeName, IThrowableProxy itp) {
        this.appendThrowableProxy(sb5, attributeName, itp, true);
    }

    protected void appendThrowableProxy(StringBuilder sb5, String attributeName, IThrowableProxy itp, boolean appendValueSeparator) {
        IThrowableProxy[] suppressedArray;
        IThrowableProxy cause;
        if (appendValueSeparator) {
            sb5.append(',');
        }
        if (attributeName != null) {
            sb5.append('\"').append(attributeName).append(QUOTE_COL);
            if (itp == null) {
                sb5.append("null");
                return;
            }
        }
        sb5.append('{');
        this.appenderMember(sb5, CLASS_NAME_ATTR_NAME, this.nullSafeStr(itp.getClassName()));
        sb5.append(',');
        this.appenderMember(sb5, MESSAGE_ATTR_NAME, this.jsonEscape(itp.getMessage()));
        if (itp.isCyclic()) {
            sb5.append(',');
            this.appenderMember(sb5, CYCLIC_THROWABLE_ATTR_NAME, this.jsonEscape("true"));
        }
        sb5.append(',');
        this.appendSTEPArray(sb5, itp.getStackTraceElementProxyArray(), itp.getCommonFrames());
        if (itp.getCommonFrames() != 0) {
            sb5.append(',');
            this.appenderMemberWithIntValue(sb5, COMMON_FRAMES_COUNT_ATTR_NAME, itp.getCommonFrames());
        }
        if ((cause = itp.getCause()) != null) {
            this.appendThrowableProxy(sb5, CAUSE_ATTR_NAME, cause);
        }
        if ((suppressedArray = itp.getSuppressed()) != null && suppressedArray.length != 0) {
            sb5.append(',');
            sb5.append('\"').append(SUPPRESSED_ATTR_NAME).append(QUOTE_COL);
            sb5.append('[');
            boolean first = true;
            for (IThrowableProxy suppressedITP : suppressedArray) {
                this.appendThrowableProxy(sb5, null, suppressedITP, !first);
                if (!first) continue;
                first = false;
            }
            sb5.append(']');
        }
        sb5.append('}');
    }

    protected void appendSTEPArray(StringBuilder sb5, StackTraceElementProxy[] stepArray, int commonFrames) {
        sb5.append('\"').append(STEP_ARRAY_NAME_ATTRIBUTE).append(QUOTE_COL).append('[');
        if (stepArray == null || stepArray.length == 0) {
            sb5.append(']');
            return;
        }
        int len = stepArray.length;
        if (commonFrames >= len) {
            commonFrames = 0;
        }
        for (int i15 = 0; i15 < len - commonFrames; ++i15) {
            if (i15 != 0) {
                sb5.append(',');
            }
            StackTraceElementProxy step = stepArray[i15];
            sb5.append('{');
            StackTraceElement ste = step.getStackTraceElement();
            this.appenderMember(sb5, CLASS_NAME_ATTR_NAME, this.nullSafeStr(ste.getClassName()));
            sb5.append(',');
            this.appenderMember(sb5, METHOD_NAME_ATTR_NAME, this.nullSafeStr(ste.getMethodName()));
            sb5.append(',');
            this.appenderMember(sb5, FILE_NAME_ATTR_NAME, this.nullSafeStr(ste.getFileName()));
            sb5.append(',');
            this.appenderMemberWithIntValue(sb5, LINE_NUMBER_ATTR_NAME, ste.getLineNumber());
            sb5.append('}');
        }
        sb5.append(']');
    }

    protected void appendCustomFields(StringBuilder sb5, ILoggingEvent event) {
    }

    protected void appenderMember(StringBuilder sb5, String key, String value) {
        sb5.append('\"').append(key).append(QUOTE_COL).append('\"').append(value).append('\"');
    }

    protected void appenderMemberWithIntValue(StringBuilder sb5, String key, int value) {
        sb5.append('\"').append(key).append(QUOTE_COL).append(value);
    }

    protected void appenderMemberWithLongValue(StringBuilder sb5, String key, long value) {
        sb5.append('\"').append(key).append(QUOTE_COL).append(value);
    }

    protected void appendKeyValuePairs(StringBuilder sb5, ILoggingEvent event) {
        List<KeyValuePair> kvpList = event.getKeyValuePairs();
        if (kvpList == null || kvpList.isEmpty()) {
            return;
        }
        sb5.append(',');
        sb5.append('\"').append(KEY_VALUE_PAIRS_ATTR_NAME).append(QUOTE_COL).append(' ').append('[');
        int len = kvpList.size();
        for (int i15 = 0; i15 < len; ++i15) {
            if (i15 != 0) {
                sb5.append(',');
            }
            KeyValuePair kvp = kvpList.get(i15);
            sb5.append('{');
            this.appenderMember(sb5, this.jsonEscapedToString(kvp.key), this.jsonEscapedToString(kvp.value));
            sb5.append('}');
        }
        sb5.append(']');
    }

    protected void appendArgumentArray(StringBuilder sb5, ILoggingEvent event) {
        Object[] argumentArray = event.getArgumentArray();
        if (argumentArray == null) {
            return;
        }
        sb5.append(',');
        sb5.append('\"').append(ARGUMENT_ARRAY_ATTR_NAME).append(QUOTE_COL).append(' ').append('[');
        int len = argumentArray.length;
        for (int i15 = 0; i15 < len; ++i15) {
            if (i15 != 0) {
                sb5.append(',');
            }
            sb5.append('\"').append(this.jsonEscapedToString(argumentArray[i15])).append('\"');
        }
        sb5.append(']');
    }

    protected void appendMarkers(StringBuilder sb5, ILoggingEvent event) {
        List<Marker> markerList = event.getMarkerList();
        if (markerList == null) {
            return;
        }
        sb5.append(',');
        sb5.append('\"').append(MARKERS_ATTR_NAME).append(QUOTE_COL).append(' ').append('[');
        int len = markerList.size();
        for (int i15 = 0; i15 < len; ++i15) {
            if (i15 != 0) {
                sb5.append(',');
            }
            sb5.append('\"').append(this.jsonEscapedToString(markerList.get(i15))).append('\"');
        }
        sb5.append(']');
    }

    private String jsonEscapedToString(Object o15) {
        if (o15 == null) {
            return "null";
        }
        return JsonEscapeUtil.jsonEscapeString(o15.toString());
    }

    private String nullSafeStr(String s15) {
        if (s15 == null) {
            return "null";
        }
        return s15;
    }

    private String jsonEscape(String s15) {
        if (s15 == null) {
            return "null";
        }
        return JsonEscapeUtil.jsonEscapeString(s15);
    }

    protected void appendMDC(StringBuilder sb5, ILoggingEvent event) {
        Map<String, String> map = event.getMDCPropertyMap();
        sb5.append(',');
        sb5.append('\"').append(MDC_ATTR_NAME).append(QUOTE_COL).append(' ').append('{');
        if (this.isNotEmptyMap(map)) {
            Set<Map.Entry<String, String>> entrySet = map.entrySet();
            int i15 = 0;
            for (Map.Entry<String, String> entry : entrySet) {
                if (i15 != 0) {
                    sb5.append(',');
                }
                this.appenderMember(sb5, this.jsonEscapedToString(entry.getKey()), this.jsonEscapedToString(entry.getValue()));
                ++i15;
            }
        }
        sb5.append('}');
    }

    boolean isNotEmptyMap(Map<?, ?> map) {
        if (map == null) {
            return false;
        }
        return !map.isEmpty();
    }

    @Override
    public byte[] footerBytes() {
        return EMPTY_BYTES;
    }

    public void setWithSequenceNumber(boolean withSequenceNumber) {
        this.withSequenceNumber = withSequenceNumber;
    }

    public void setWithTimestamp(boolean withTimestamp) {
        this.withTimestamp = withTimestamp;
    }

    public void setWithNanoseconds(boolean withNanoseconds) {
        this.withNanoseconds = withNanoseconds;
    }

    public void setWithLevel(boolean withLevel) {
        this.withLevel = withLevel;
    }

    public void setWithThreadName(boolean withThreadName) {
        this.withThreadName = withThreadName;
    }

    public void setWithLoggerName(boolean withLoggerName) {
        this.withLoggerName = withLoggerName;
    }

    public void setWithContext(boolean withContext) {
        this.withContext = withContext;
    }

    public void setWithMarkers(boolean withMarkers) {
        this.withMarkers = withMarkers;
    }

    public void setWithMDC(boolean withMDC) {
        this.withMDC = withMDC;
    }

    public void setWithKVPList(boolean withKVPList) {
        this.withKVPList = withKVPList;
    }

    public void setWithMessage(boolean withMessage) {
        this.withMessage = withMessage;
    }

    public void setWithArguments(boolean withArguments) {
        this.withArguments = withArguments;
    }

    public void setWithThrowable(boolean withThrowable) {
        this.withThrowable = withThrowable;
    }

    public void setWithFormattedMessage(boolean withFormattedMessage) {
        this.withFormattedMessage = withFormattedMessage;
    }
}

