/*
 * Decompiled with CFR 0.152.
 */
package antlr;

public class CharQueue {
    protected char[] buffer;
    private int sizeLessOne;
    private int offset;
    protected int nbrEntries;

    public CharQueue(int n15) {
        int n16;
        if (n15 < 0) {
            this.init(16);
            return;
        }
        if (n15 >= 0x3FFFFFFF) {
            this.init(Integer.MAX_VALUE);
            return;
        }
        for (n16 = 2; n16 < n15; n16 *= 2) {
        }
        this.init(n16);
    }

    public final void append(char c15) {
        if (this.nbrEntries == this.buffer.length) {
            this.expand();
        }
        this.buffer[this.offset + this.nbrEntries & this.sizeLessOne] = c15;
        ++this.nbrEntries;
    }

    public final char elementAt(int n15) {
        return this.buffer[this.offset + n15 & this.sizeLessOne];
    }

    private final void expand() {
        char[] cArray = new char[this.buffer.length * 2];
        for (int i15 = 0; i15 < this.buffer.length; ++i15) {
            cArray[i15] = this.elementAt(i15);
        }
        this.buffer = cArray;
        this.sizeLessOne = this.buffer.length - 1;
        this.offset = 0;
    }

    public void init(int n15) {
        this.buffer = new char[n15];
        this.sizeLessOne = n15 - 1;
        this.offset = 0;
        this.nbrEntries = 0;
    }

    public final void reset() {
        this.offset = 0;
        this.nbrEntries = 0;
    }

    public final void removeFirst() {
        this.offset = this.offset + 1 & this.sizeLessOne;
        --this.nbrEntries;
    }
}

