/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package kotlin.reflect.jvm.internal.impl.types

import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind
import kotlin.reflect.jvm.internal.impl.utils.IDEAPlatforms.*
import kotlin.reflect.jvm.internal.impl.utils.IDEAPluginsCompatibilityAPI

@Suppress("unused", "UNUSED_PARAMETER")
@IDEAPluginsCompatibilityAPI(
    _212, _213, _221,
    message = "Please migrate to the kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils",
    plugins = "android/safeargs"
)
object ErrorUtils {
    @IDEAPluginsCompatibilityAPI(
        _212, _213, _221,
        message = "Please migrate to the kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils",
        plugins = "android/safeargs"
    )
    @JvmStatic
    fun createUnresolvedType(presentableName: String, arguments: List<TypeProjection>): SimpleType {
        return kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils.createErrorTypeWithArguments(
            ErrorTypeKind.UNRESOLVED_TYPE, arguments, this.toString()
        )
    }

    @IDEAPluginsCompatibilityAPI(
        _213, _221,
        message = "Please migrate to the kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils",
        plugins = "mobile-ide/kotlin-ocswift"
    )
    @JvmStatic
    fun createErrorType(debugMessage: String): SimpleType {
        return kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE, debugMessage)
    }
}
