/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.codeInspection.utils.SideEffectChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public final class GroovyDoubleCheckedLockingInspection
extends BaseInspection {
    public boolean ignoreOnVolatileVariables = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GroovyBundle.message("inspection.message.double.checked.locking", new Object[0]);
        if (string == null) {
            GroovyDoubleCheckedLockingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public OptPane getGroovyOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreOnVolatileVariables", (String)GroovyBundle.message("checkbox.ignore.double.checked.locking.on.volatile.fields", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            GroovyDoubleCheckedLockingInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleCheckedLockingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyDoubleCheckedLockingInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class DoubleCheckedLockingVisitor
    extends BaseInspectionVisitor {
        private DoubleCheckedLockingVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            if (statement == null) {
                DoubleCheckedLockingVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            GrExpression outerCondition = statement.getCondition();
            if (outerCondition == null) {
                return;
            }
            if (SideEffectChecker.mayHaveSideEffects(outerCondition)) {
                return;
            }
            GrStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (!((thenBranch = ControlFlowUtils.stripBraces(thenBranch)) instanceof GrSynchronizedStatement)) {
                return;
            }
            GrSynchronizedStatement syncStatement = (GrSynchronizedStatement)thenBranch;
            GrOpenBlock body = syncStatement.getBody();
            if (body == null) {
                return;
            }
            GrStatement[] statements = body.getStatements();
            if (statements.length != 1) {
                return;
            }
            GrStatement grStatement = statements[0];
            if (!(grStatement instanceof GrIfStatement)) {
                return;
            }
            GrIfStatement innerIf = (GrIfStatement)grStatement;
            GrExpression innerCondition = innerIf.getCondition();
            if (innerCondition == null) {
                return;
            }
            if (!EquivalenceChecker.expressionsAreEquivalent(innerCondition, outerCondition)) {
                return;
            }
            if (GroovyDoubleCheckedLockingInspection.this.ignoreOnVolatileVariables && DoubleCheckedLockingVisitor.ifStatementAssignsVolatileVariable(innerIf)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private static boolean ifStatementAssignsVolatileVariable(GrIfStatement statement) {
            GrStatement innerThen = statement.getThenBranch();
            if (!((innerThen = ControlFlowUtils.stripBraces(innerThen)) instanceof GrAssignmentExpression)) {
                return false;
            }
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)innerThen;
            GrExpression lhs = assignmentExpression.getLValue();
            if (!(lhs instanceof GrReferenceExpression)) {
                return false;
            }
            GrReferenceExpression referenceExpression = (GrReferenceExpression)lhs;
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiField)) {
                return false;
            }
            PsiField field2 = (PsiField)element;
            return field2.hasModifierProperty("volatile");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyDoubleCheckedLockingInspection$DoubleCheckedLockingVisitor", "visitIfStatement"));
        }
    }
}

