/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.xml;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.parsing.xml.XmlParsing;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.IXmlAttributeElementType;
import com.intellij.psi.xml.IXmlTagElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.Stack;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.xml.util.BasicXmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlBuilderDriver {
    private final Stack<@NotNull String> myNamespacesStack;
    private final Stack<@NotNull String> myPrefixesStack;
    private final CharSequence myText;
    @NonNls
    private static final String XMLNS = "xmlns";
    @NonNls
    private static final String XMLNS_COLON = "xmlns:";

    public XmlBuilderDriver(@NotNull CharSequence text) {
        if (text == null) {
            XmlBuilderDriver.$$$reportNull$$$0(0);
        }
        this.myNamespacesStack = new Stack();
        this.myPrefixesStack = new Stack();
        this.myText = text;
    }

    @NotNull
    protected CharSequence getText() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            XmlBuilderDriver.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public void addImplicitBinding(@NonNls @NotNull String prefix, @NonNls @NotNull String namespace) {
        if (prefix == null) {
            XmlBuilderDriver.$$$reportNull$$$0(2);
        }
        if (namespace == null) {
            XmlBuilderDriver.$$$reportNull$$$0(3);
        }
        this.myNamespacesStack.push((Object)namespace);
        this.myPrefixesStack.push((Object)prefix);
    }

    public void build(@NotNull XmlBuilder builder) {
        if (builder == null) {
            XmlBuilderDriver.$$$reportNull$$$0(4);
        }
        PsiBuilder b = this.createBuilderAndParse();
        FlyweightCapableTreeStructure structure = b.getLightTree();
        LighterASTNode root = (LighterASTNode)structure.getRoot();
        Ref childrenRef = Ref.create(null);
        int count = structure.getChildren((Object)root, childrenRef);
        Object[] children = (LighterASTNode[])childrenRef.get();
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children[i];
            IElementType tt = child.getTokenType();
            if (tt instanceof IXmlTagElementType) {
                this.processTagNode((FlyweightCapableTreeStructure<LighterASTNode>)structure, child, builder);
                continue;
            }
            if (tt != XmlElementType.XML_PROLOG) continue;
            this.processPrologNode(builder, (FlyweightCapableTreeStructure<LighterASTNode>)structure, child);
        }
        structure.disposeChildren(children, count);
    }

    private void processPrologNode(@NotNull XmlBuilder builder, @NotNull FlyweightCapableTreeStructure<LighterASTNode> structure, @NotNull LighterASTNode prolog) {
        if (builder == null) {
            XmlBuilderDriver.$$$reportNull$$$0(5);
        }
        if (structure == null) {
            XmlBuilderDriver.$$$reportNull$$$0(6);
        }
        if (prolog == null) {
            XmlBuilderDriver.$$$reportNull$$$0(7);
        }
        Ref prologChildren = new Ref(null);
        int prologChildrenCount = structure.getChildren((Object)prolog, prologChildren);
        for (int i = 0; i < prologChildrenCount; ++i) {
            LighterASTNode node = ((LighterASTNode[])prologChildren.get())[i];
            IElementType type = node.getTokenType();
            if (type == XmlElementType.XML_DOCTYPE) {
                this.processDoctypeNode(builder, structure, node);
                break;
            }
            if (type != TokenType.ERROR_ELEMENT) continue;
            XmlBuilderDriver.processErrorNode(node, builder);
        }
    }

    private void processDoctypeNode(@NotNull XmlBuilder builder, @NotNull FlyweightCapableTreeStructure<LighterASTNode> structure, @NotNull LighterASTNode doctype) {
        Ref tokens;
        int tokenCount;
        if (builder == null) {
            XmlBuilderDriver.$$$reportNull$$$0(8);
        }
        if (structure == null) {
            XmlBuilderDriver.$$$reportNull$$$0(9);
        }
        if (doctype == null) {
            XmlBuilderDriver.$$$reportNull$$$0(10);
        }
        if ((tokenCount = structure.getChildren((Object)doctype, tokens = new Ref(null))) > 0) {
            CharSequence publicId = null;
            boolean afterPublic = false;
            CharSequence systemId = null;
            boolean afterSystem = false;
            for (int i = 0; i < tokenCount; ++i) {
                LighterASTNode token = ((LighterASTNode[])tokens.get())[i];
                if (token.getTokenType() == XmlTokenType.XML_DOCTYPE_PUBLIC) {
                    afterPublic = true;
                    continue;
                }
                if (token.getTokenType() == XmlTokenType.XML_DOCTYPE_SYSTEM) {
                    afterSystem = true;
                    continue;
                }
                if (token.getTokenType() == TokenType.WHITE_SPACE || token.getTokenType() == XmlElementType.XML_COMMENT) continue;
                if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                    if (afterPublic) {
                        publicId = this.getTokenText(token);
                    } else if (afterSystem) {
                        systemId = this.getTokenText(token);
                    }
                }
                afterSystem = false;
                afterPublic = false;
            }
            builder.doctype(publicId, systemId, doctype.getStartOffset(), doctype.getEndOffset());
        }
    }

    @NotNull
    private CharSequence getTokenText(@NotNull LighterASTNode token) {
        if (token == null) {
            XmlBuilderDriver.$$$reportNull$$$0(11);
        }
        CharSequence charSequence = this.myText.subSequence(token.getStartOffset(), token.getEndOffset());
        if (charSequence == null) {
            XmlBuilderDriver.$$$reportNull$$$0(12);
        }
        return charSequence;
    }

    @NotNull
    protected PsiBuilder createBuilderAndParse() {
        ParserDefinition xmlParserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)XMLLanguage.INSTANCE);
        assert (xmlParserDefinition != null);
        PsiBuilder b = PsiBuilderFactory.getInstance().createBuilder(xmlParserDefinition, xmlParserDefinition.createLexer(null), this.myText);
        new XmlParsing(b).parseDocument();
        PsiBuilder psiBuilder = b;
        if (psiBuilder == null) {
            XmlBuilderDriver.$$$reportNull$$$0(13);
        }
        return psiBuilder;
    }

    private static void processErrorNode(@NotNull LighterASTNode node, @NotNull XmlBuilder builder) {
        if (node == null) {
            XmlBuilderDriver.$$$reportNull$$$0(14);
        }
        if (builder == null) {
            XmlBuilderDriver.$$$reportNull$$$0(15);
        }
        assert (node.getTokenType() == TokenType.ERROR_ELEMENT);
        String message = PsiBuilderImpl.getErrorMessage((LighterASTNode)node);
        assert (message != null);
        builder.error(message, node.getStartOffset(), node.getEndOffset());
    }

    private void processTagNode(@NotNull FlyweightCapableTreeStructure<LighterASTNode> structure, @NotNull LighterASTNode node, @NotNull XmlBuilder builder) {
        String namespace;
        CharSequence localName;
        XmlBuilder.ProcessingOrder order;
        if (structure == null) {
            XmlBuilderDriver.$$$reportNull$$$0(16);
        }
        if (node == null) {
            XmlBuilderDriver.$$$reportNull$$$0(17);
        }
        if (builder == null) {
            XmlBuilderDriver.$$$reportNull$$$0(18);
        }
        IElementType nodeTT = node.getTokenType();
        assert (nodeTT instanceof IXmlTagElementType);
        Ref childrenRef = Ref.create(null);
        int count = structure.getChildren((Object)node, childrenRef);
        Object[] children = (LighterASTNode[])childrenRef.get();
        int stackFrameSize = this.myNamespacesStack.size();
        CharSequence tagName = "";
        int headerEndOffset = node.getEndOffset();
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children[i];
            IElementType tt = child.getTokenType();
            if (tt instanceof IXmlAttributeElementType) {
                this.checkForXmlns(child, structure);
            }
            if (tt == XmlTokenType.XML_TAG_END || tt == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                headerEndOffset = child.getEndOffset();
                break;
            }
            if (tt != XmlTokenType.XML_NAME && tt != XmlTokenType.XML_TAG_NAME) continue;
            tagName = this.getTokenText(child);
        }
        boolean processAttrs = (order = builder.startTag(localName = BasicXmlUtil.getLocalName(tagName), namespace = this.getNamespace(tagName), node.getStartOffset(), node.getEndOffset(), headerEndOffset)) == XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES || order == XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES_AND_TEXTS;
        boolean processTexts = order == XmlBuilder.ProcessingOrder.TAGS_AND_TEXTS || order == XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES_AND_TEXTS;
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children[i];
            IElementType tt = child.getTokenType();
            if (tt == TokenType.ERROR_ELEMENT) {
                XmlBuilderDriver.processErrorNode(child, builder);
            }
            if (tt instanceof IXmlTagElementType) {
                this.processTagNode(structure, child, builder);
            }
            if (processAttrs && tt instanceof IXmlAttributeElementType) {
                this.processAttributeNode(child, structure, builder);
            }
            if (processTexts && tt == XmlElementType.XML_TEXT) {
                this.processTextNode(structure, child, builder);
            }
            if (tt != XmlElementType.XML_ENTITY_REF) continue;
            builder.entityRef(this.getTokenText(child), child.getStartOffset(), child.getEndOffset());
        }
        builder.endTag(localName, namespace, node.getStartOffset(), node.getEndOffset());
        int framesToDrop = this.myNamespacesStack.size() - stackFrameSize;
        for (int i = 0; i < framesToDrop; ++i) {
            this.myNamespacesStack.pop();
            this.myPrefixesStack.pop();
        }
        structure.disposeChildren(children, count);
    }

    private void processTextNode(@NotNull FlyweightCapableTreeStructure<LighterASTNode> structure, @NotNull LighterASTNode node, @NotNull XmlBuilder builder) {
        if (structure == null) {
            XmlBuilderDriver.$$$reportNull$$$0(19);
        }
        if (node == null) {
            XmlBuilderDriver.$$$reportNull$$$0(20);
        }
        if (builder == null) {
            XmlBuilderDriver.$$$reportNull$$$0(21);
        }
        Ref childrenRef = Ref.create(null);
        int count = structure.getChildren((Object)node, childrenRef);
        Object[] children = (LighterASTNode[])childrenRef.get();
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children[i];
            IElementType tt = child.getTokenType();
            int start = child.getStartOffset();
            int end = child.getEndOffset();
            CharSequence physical = this.getTokenText(child);
            if (XmlTokenType.COMMENTS.contains(tt)) continue;
            if (tt == XmlTokenType.XML_CDATA_START || tt == XmlTokenType.XML_CDATA_END) {
                builder.textElement("", physical, start, end);
                continue;
            }
            if (tt == XmlElementType.XML_CDATA) {
                this.processTextNode(structure, child, builder);
                continue;
            }
            if (tt == XmlTokenType.XML_CHAR_ENTITY_REF) {
                builder.textElement(new String(new char[]{BasicXmlUtil.getCharFromEntityRef(physical.toString())}), physical, start, end);
                continue;
            }
            builder.textElement(physical, physical, start, end);
        }
        structure.disposeChildren(children, count);
    }

    private void processAttributeNode(@NotNull LighterASTNode attrNode, @NotNull FlyweightCapableTreeStructure<LighterASTNode> structure, @NotNull XmlBuilder builder) {
        if (attrNode == null) {
            XmlBuilderDriver.$$$reportNull$$$0(22);
        }
        if (structure == null) {
            XmlBuilderDriver.$$$reportNull$$$0(23);
        }
        if (builder == null) {
            XmlBuilderDriver.$$$reportNull$$$0(24);
        }
        builder.attribute(this.getAttributeName(attrNode, structure), this.getAttributeValue(attrNode, structure), attrNode.getStartOffset(), attrNode.getEndOffset());
    }

    @NonNls
    @NotNull
    private String getNamespace(@NotNull CharSequence tagName) {
        int pos;
        if (tagName == null) {
            XmlBuilderDriver.$$$reportNull$$$0(25);
        }
        String namespacePrefix = (pos = StringUtil.indexOf((CharSequence)tagName, (char)':')) == -1 ? "" : tagName.subSequence(0, pos).toString();
        for (int i = this.myPrefixesStack.size() - 1; i >= 0; --i) {
            if (!namespacePrefix.equals(this.myPrefixesStack.get(i))) continue;
            String string = (String)this.myNamespacesStack.get(i);
            if (string == null) {
                XmlBuilderDriver.$$$reportNull$$$0(26);
            }
            return string;
        }
        return "";
    }

    private void checkForXmlns(@NotNull LighterASTNode attrNode, @NotNull FlyweightCapableTreeStructure<LighterASTNode> structure) {
        CharSequence name;
        if (attrNode == null) {
            XmlBuilderDriver.$$$reportNull$$$0(27);
        }
        if (structure == null) {
            XmlBuilderDriver.$$$reportNull$$$0(28);
        }
        if (Comparing.equal((CharSequence)(name = this.getAttributeName(attrNode, structure)), (CharSequence)XMLNS)) {
            this.myPrefixesStack.push((Object)"");
            this.myNamespacesStack.push((Object)this.getAttributeValue(attrNode, structure).toString());
        } else if (StringUtil.startsWith((CharSequence)name, (CharSequence)XMLNS_COLON)) {
            this.myPrefixesStack.push((Object)name.subSequence(XMLNS_COLON.length(), name.length()).toString());
            this.myNamespacesStack.push((Object)this.getAttributeValue(attrNode, structure).toString());
        }
    }

    @NotNull
    private CharSequence getAttributeName(@NotNull LighterASTNode attrNode, @NotNull FlyweightCapableTreeStructure<LighterASTNode> structure) {
        if (attrNode == null) {
            XmlBuilderDriver.$$$reportNull$$$0(29);
        }
        if (structure == null) {
            XmlBuilderDriver.$$$reportNull$$$0(30);
        }
        return this.findTextByTokenType(attrNode, structure, XmlTokenType.XML_NAME);
    }

    @NotNull
    private CharSequence getAttributeValue(@NotNull LighterASTNode attrNode, @NotNull FlyweightCapableTreeStructure<LighterASTNode> structure) {
        if (attrNode == null) {
            XmlBuilderDriver.$$$reportNull$$$0(31);
        }
        if (structure == null) {
            XmlBuilderDriver.$$$reportNull$$$0(32);
        }
        CharSequence fullValue = this.findTextByTokenType(attrNode, structure, XmlElementType.XML_ATTRIBUTE_VALUE);
        int start = 0;
        if (!fullValue.isEmpty() && fullValue.charAt(0) == '\"') {
            ++start;
        }
        int end = fullValue.length();
        if (fullValue.length() > start && fullValue.charAt(fullValue.length() - 1) == '\"') {
            --end;
        }
        CharSequence charSequence = fullValue.subSequence(start, end);
        if (charSequence == null) {
            XmlBuilderDriver.$$$reportNull$$$0(33);
        }
        return charSequence;
    }

    @NotNull
    private CharSequence findTextByTokenType(@NotNull LighterASTNode attrNode, @NotNull FlyweightCapableTreeStructure<LighterASTNode> structure, @NotNull IElementType tt) {
        if (attrNode == null) {
            XmlBuilderDriver.$$$reportNull$$$0(34);
        }
        if (structure == null) {
            XmlBuilderDriver.$$$reportNull$$$0(35);
        }
        if (tt == null) {
            XmlBuilderDriver.$$$reportNull$$$0(36);
        }
        Ref childrenRef = Ref.create(null);
        int count = structure.getChildren((Object)attrNode, childrenRef);
        Object[] children = (LighterASTNode[])childrenRef.get();
        CharSequence name = "";
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children[i];
            if (child.getTokenType() != tt) continue;
            name = this.getTokenText(child);
            break;
        }
        structure.disposeChildren(children, count);
        String string = name;
        if (string == null) {
            XmlBuilderDriver.$$$reportNull$$$0(37);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 12, 13, 26, 33, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 26: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/parsing/xml/XmlBuilderDriver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 9: 
            case 16: 
            case 19: 
            case 23: 
            case 28: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prolog";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doctype";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 22: 
            case 27: 
            case 29: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrNode";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/parsing/xml/XmlBuilderDriver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilderAndParse";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValue";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findTextByTokenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 26: 
            case 33: 
            case 37: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitBinding";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processPrologNode";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processDoctypeNode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTokenText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processErrorNode";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processTagNode";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processTextNode";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processAttributeNode";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkForXmlns";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeName";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findTextByTokenType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 12, 13, 26, 33, 37 -> new IllegalStateException(string);
        };
    }
}

