/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.analysis;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.analysis.AnalyseKt;
import com.intellij.coverage.analysis.AnalysisUtils;
import com.intellij.coverage.analysis.ModuleRequest;
import com.intellij.coverage.analysis.RequestRoot;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCoverageClassesEnumerator {
    protected final CoverageSuitesBundle mySuite;
    protected final Project myProject;
    protected final CoverageDataManager myCoverageManager;
    private int myRootsCount;
    private int myCurrentRootsCount;

    public JavaCoverageClassesEnumerator(@NotNull CoverageSuitesBundle suite, @NotNull Project project) {
        if (suite == null) {
            JavaCoverageClassesEnumerator.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JavaCoverageClassesEnumerator.$$$reportNull$$$0(1);
        }
        this.mySuite = suite;
        this.myProject = project;
        this.myCoverageManager = CoverageDataManager.getInstance((Project)this.myProject);
    }

    protected void visitClassFiles(String topLevelClassName, List<File> files, String packageVMName) {
    }

    public void visitSuite() {
        Map<ModuleRequest, List<RequestRoot>> roots = AnalyseKt.collectOutputRoots(this.mySuite, this.myProject);
        this.myRootsCount = roots.values().stream().mapToInt(List::size).sum();
        this.myCurrentRootsCount = 0;
        this.updateProgress();
        for (Map.Entry<ModuleRequest, List<RequestRoot>> e : roots.entrySet()) {
            Module module = e.getKey().getModule();
            String packageVMName = AnalysisUtils.fqnToInternalName(e.getKey().getPackageName());
            this.visitSource(module, packageVMName, e.getValue());
        }
    }

    protected void visitSource(Module module, String rootPackageVMName, List<RequestRoot> roots) {
        for (RequestRoot request : roots) {
            this.visitRoot(request.getRoot(), rootPackageVMName, request.getSimpleName());
        }
    }

    protected void visitRoot(File packageOutputRoot, String rootPackageVMName, @Nullable String requestedSimpleName) {
        Stack stack = new Stack((Object[])new PackageData[]{new PackageData(rootPackageVMName, packageOutputRoot.listFiles())});
        while (!stack.isEmpty()) {
            ProgressIndicatorProvider.checkCanceled();
            PackageData packageData = (PackageData)stack.pop();
            String packageVMName = packageData.packageVMName;
            File[] children = packageData.children;
            if (children == null) continue;
            HashMap<String, List> topLevelClasses = new HashMap<String, List>();
            for (File child : children) {
                if (AnalysisUtils.isClassFile(child)) {
                    String simpleName = AnalysisUtils.getClassName(child);
                    String classFqVMName = AnalysisUtils.buildVMName(packageVMName, simpleName);
                    String toplevelClassSrcFQName = AnalysisUtils.getSourceToplevelFQName(classFqVMName);
                    topLevelClasses.computeIfAbsent(toplevelClassSrcFQName, k -> new ArrayList()).add(child);
                    continue;
                }
                if (requestedSimpleName != null || !child.isDirectory()) continue;
                String childPackageVMName = AnalysisUtils.buildVMName(packageVMName, child.getName());
                stack.push((Object)new PackageData(childPackageVMName, child.listFiles()));
            }
            String requestedTopLevelName = requestedSimpleName == null ? null : AnalysisUtils.internalNameToFqn(AnalysisUtils.buildVMName(packageVMName, requestedSimpleName));
            for (Map.Entry entry : topLevelClasses.entrySet()) {
                String topLevelClassName = (String)entry.getKey();
                if (requestedTopLevelName != null && !requestedTopLevelName.equals(topLevelClassName)) continue;
                this.visitClassFiles(topLevelClassName, (List)entry.getValue(), packageVMName);
            }
        }
        ++this.myCurrentRootsCount;
        this.updateProgress();
    }

    private void updateProgress() {
        if (this.myRootsCount <= 1) {
            return;
        }
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator == null) {
            return;
        }
        progressIndicator.setIndeterminate(false);
        progressIndicator.setFraction((double)this.myCurrentRootsCount / (double)this.myRootsCount);
    }

    public static VirtualFile @NotNull [] getRoots(CoverageDataManager manager, Module module, boolean includeTests) {
        VirtualFile[] files = (VirtualFile[])manager.doInReadActionIfProjectOpen(() -> {
            OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutLibraries().withoutDepModules();
            if (!includeTests) {
                enumerator = enumerator.productionOnly();
            }
            return enumerator.classes().getRoots();
        });
        if (files == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                JavaCoverageClassesEnumerator.$$$reportNull$$$0(2);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        if (files == null) {
            JavaCoverageClassesEnumerator.$$$reportNull$$$0(3);
        }
        return files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/analysis/JavaCoverageClassesEnumerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/analysis/JavaCoverageClassesEnumerator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private record PackageData(String packageVMName, File[] children) {
    }
}

