/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.invocation;

import com.google.common.collect.ImmutableList;
import groovy.lang.Closure;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.IsolatedAction;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.BuildScopeListenerRegistrationListener;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.invocation.GradleLifecycle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.initialization.ClassLoaderScopeRegistry;
import org.gradle.initialization.SettingsState;
import org.gradle.internal.Cast;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.InternalListener;
import org.gradle.internal.MutableActionSet;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.internal.resource.TextUriResourceLoader;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.invocation.GradleLifecycleActionExecutor;
import org.gradle.invocation.IsolatedProjectEvaluationListenerProvider;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.util.GradleVersion;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public abstract class DefaultGradle
extends AbstractPluginAware
implements GradleInternal,
Closeable {
    private final BuildState buildState;
    private final StartParameter startParameter;
    private final ServiceRegistry buildScopeServices;
    private final CrossProjectConfigurator crossProjectConfigurator;
    private final IsolatedProjectEvaluationListenerProvider isolatedProjectEvaluationListenerProvider;
    private final GradleLifecycleActionExecutor gradleLifecycleActionExecutor;
    private final ListenerBroadcast<BuildListener> buildListenerBroadcast;
    private final ListenerBroadcast<ProjectEvaluationListener> projectEvaluationListenerBroadcast;
    private final MutableActionSet<Project> rootProjectActions = new MutableActionSet();
    private @Nullable List<IncludedBuildInternal> includedBuilds;
    private @Nullable GradleLifecycle lifecycle;
    private @Nullable Supplier<? extends ClassLoaderScope> classLoaderScope;
    private @Nullable ClassLoaderScope baseProjectClassLoaderScope;
    private @Nullable SettingsState settings;
    private @Nullable ProjectInternal rootProject;
    private @Nullable ProjectInternal defaultProject;
    private boolean projectsLoaded;

    public DefaultGradle(BuildState buildState, StartParameter startParameter, final ServiceRegistry buildScopeServices) {
        this.buildState = buildState;
        this.startParameter = startParameter;
        this.buildScopeServices = buildScopeServices;
        this.crossProjectConfigurator = (CrossProjectConfigurator)buildScopeServices.get(CrossProjectConfigurator.class);
        this.isolatedProjectEvaluationListenerProvider = (IsolatedProjectEvaluationListenerProvider)buildScopeServices.get(IsolatedProjectEvaluationListenerProvider.class);
        this.gradleLifecycleActionExecutor = (GradleLifecycleActionExecutor)buildScopeServices.get(GradleLifecycleActionExecutor.class);
        this.buildListenerBroadcast = this.getListenerManager().createAnonymousBroadcaster(BuildListener.class);
        this.projectEvaluationListenerBroadcast = this.getListenerManager().createAnonymousBroadcaster(ProjectEvaluationListener.class);
        this.buildListenerBroadcast.add((Object)new InternalBuildAdapter(){

            public void projectsLoaded(Gradle gradle) {
                ProjectEvaluationListener isolatedListener = DefaultGradle.this.isolatedProjectEvaluationListenerProvider.isolateFor(DefaultGradle.this);
                if (!DefaultGradle.this.rootProjectActions.isEmpty()) {
                    DefaultGradle.this.gradleLifecycleActionExecutor.executeBeforeProjectFor(DefaultGradle.this.rootProject);
                    ((CrossProjectConfigurator)buildScopeServices.get(CrossProjectConfigurator.class)).rootProject(DefaultGradle.this.rootProject, (Action<? super Project>)DefaultGradle.this.rootProjectActions);
                }
                if (isolatedListener != null) {
                    DefaultGradle.this.projectEvaluationListenerBroadcast.add((Object)isolatedListener);
                }
                DefaultGradle.this.projectsLoaded = true;
            }
        });
        if (buildState.getParent() == null) {
            ((GradleEnterprisePluginManager)buildScopeServices.get(GradleEnterprisePluginManager.class)).registerMissingPluginWarning(this);
        }
    }

    public String toString() {
        return this.rootProject == null ? "build" : "build '" + this.rootProject.getName() + "'";
    }

    public String getBuildPath() {
        return this.getIdentityPath().asString();
    }

    @Override
    public Path getIdentityPath() {
        return this.buildState.getIdentityPath();
    }

    @Override
    public String contextualize(String description) {
        if (this.isRootBuild()) {
            return description;
        }
        return description + " (" + this.getIdentityPath().asString() + ")";
    }

    @Override
    public @Nullable GradleInternal getParent() {
        BuildState parent = this.buildState.getParent();
        return parent == null ? null : parent.getMutableModel();
    }

    @Override
    public GradleInternal getRoot() {
        GradleInternal parent = this.getParent();
        if (parent == null) {
            return this;
        }
        return parent.getRoot();
    }

    @Override
    public boolean isRootBuild() {
        return this.buildState.getParent() == null;
    }

    @Override
    public BuildState getOwner() {
        return this.buildState;
    }

    public String getGradleVersion() {
        return GradleVersion.current().getVersion();
    }

    public @Nullable File getGradleHomeDir() {
        GradleInstallation gradleInstallation = this.getCurrentGradleInstallation().getInstallation();
        return gradleInstallation == null ? null : gradleInstallation.getGradleHome();
    }

    public File getGradleUserHomeDir() {
        return this.startParameter.getGradleUserHomeDir();
    }

    @Override
    public StartParameterInternal getStartParameter() {
        return (StartParameterInternal)this.startParameter;
    }

    public GradleLifecycle getLifecycle() {
        if (this.lifecycle == null) {
            this.lifecycle = this.instantiateGradleLifecycle();
        }
        return this.lifecycle;
    }

    @Override
    public void resetState() {
        this.classLoaderScope = null;
        this.baseProjectClassLoaderScope = null;
        this.rootProject = null;
        this.defaultProject = null;
        this.projectsLoaded = false;
        this.includedBuilds = null;
        this.rootProjectActions.clear();
        this.isolatedProjectEvaluationListenerProvider.clear();
        this.buildListenerBroadcast.removeAll();
        this.projectEvaluationListenerBroadcast.removeAll();
        this.getTaskGraph().resetState();
        if (this.settings != null) {
            this.settings.close();
            this.settings = null;
        }
    }

    @Override
    public void close() {
        if (this.settings != null) {
            this.settings.close();
            this.settings = null;
        }
    }

    @Override
    public ClassLoaderScope baseProjectClassLoaderScope() {
        if (this.baseProjectClassLoaderScope == null) {
            throw new IllegalStateException("baseProjectClassLoaderScope not yet set");
        }
        return this.baseProjectClassLoaderScope;
    }

    @Override
    public void setBaseProjectClassLoaderScope(ClassLoaderScope classLoaderScope) {
        if (classLoaderScope == null) {
            throw new IllegalArgumentException("classLoaderScope must not be null");
        }
        if (this.baseProjectClassLoaderScope != null) {
            throw new IllegalStateException("baseProjectClassLoaderScope is already set");
        }
        this.baseProjectClassLoaderScope = classLoaderScope;
    }

    @Override
    public SettingsInternal getSettings() {
        if (this.settings == null) {
            throw new IllegalStateException("The settings are not yet available for " + this + ".");
        }
        return this.settings.getSettings();
    }

    @Override
    public void attachSettings(@Nullable SettingsState settings) {
        if (this.settings != null) {
            this.settings.close();
        }
        this.settings = settings;
    }

    @Override
    public ProjectInternal getRootProject() {
        if (this.rootProject == null) {
            throw new IllegalStateException("The root project is not yet available for " + this + ".");
        }
        return this.rootProject;
    }

    @Override
    public void setRootProject(ProjectInternal rootProject) {
        this.rootProject = rootProject;
    }

    public void rootProject(Action<? super Project> action) {
        this.rootProject("Gradle.rootProject", action);
    }

    private void rootProject(String registrationPoint, Action<? super Project> action) {
        if (this.projectsLoaded) {
            assert (this.rootProject != null);
            action.execute((Object)this.rootProject);
        } else {
            this.rootProjectActions.add(this.decorate(registrationPoint, action));
        }
    }

    public void allprojects(Action<? super Project> action) {
        this.rootProject("Gradle.allprojects", (Action<? super Project>)((Action)project -> project.allprojects(action)));
    }

    @Override
    public ProjectInternal getDefaultProject() {
        if (this.defaultProject == null) {
            throw new IllegalStateException("The default project is not yet available for " + this + ".");
        }
        return this.defaultProject;
    }

    @Override
    public void setDefaultProject(ProjectInternal defaultProject) {
        this.defaultProject = defaultProject;
    }

    @Override
    @Inject
    public abstract TaskExecutionGraphInternal getTaskGraph();

    public ProjectEvaluationListener addProjectEvaluationListener(ProjectEvaluationListener listener) {
        this.addListener("Gradle.addProjectEvaluationListener", listener);
        return listener;
    }

    public void removeProjectEvaluationListener(ProjectEvaluationListener listener) {
        this.removeListener(listener);
    }

    private void assertProjectMutatingMethodAllowed(String methodName) {
        this.crossProjectConfigurator.getLazyBehaviorGuard().assertEagerContext(methodName, this, Gradle.class);
    }

    public void beforeProject(Closure closure) {
        this.registerProjectEvaluationListener("Gradle.beforeProject", "beforeEvaluate", "beforeProject(Closure)", closure);
    }

    public void beforeProject(Action<? super Project> action) {
        this.registerProjectEvaluationListener("Gradle.beforeProject", "beforeEvaluate", "beforeProject(Action)", action);
    }

    public void afterProject(Closure closure) {
        this.registerProjectEvaluationListener("Gradle.afterProject", "afterEvaluate", "afterProject(Closure)", closure);
    }

    public void afterProject(Action<? super Project> action) {
        this.registerProjectEvaluationListener("Gradle.afterProject", "afterEvaluate", "afterProject(Action)", action);
    }

    public void beforeSettings(Closure<?> closure) {
        this.registerBuildListener("beforeSettings", closure);
    }

    public void beforeSettings(Action<? super Settings> action) {
        this.buildListenerBroadcast.add("beforeSettings", action);
    }

    public void settingsEvaluated(Closure closure) {
        this.registerBuildListener("settingsEvaluated", closure);
    }

    public void settingsEvaluated(Action<? super Settings> action) {
        this.buildListenerBroadcast.add("settingsEvaluated", action);
    }

    public void projectsLoaded(Closure closure) {
        this.registerBuildListener("Gradle.projectsLoaded", "projectsLoaded", "projectsLoaded(Closure)", closure);
    }

    public void projectsLoaded(Action<? super Gradle> action) {
        this.registerBuildListener("Gradle.projectsLoaded", "projectsLoaded", "projectsLoaded(Action)", action);
    }

    public void projectsEvaluated(Closure closure) {
        this.registerBuildListener("Gradle.projectsEvaluated", "projectsEvaluated", "projectsEvaluated(Closure)", closure);
    }

    public void projectsEvaluated(Action<? super Gradle> action) {
        this.registerBuildListener("Gradle.projectsEvaluated", "projectsEvaluated", "projectsEvaluated(Action)", action);
    }

    @Deprecated
    public void buildFinished(Closure closure) {
        this.notifyListenerRegistration("Gradle.buildFinished", closure);
        this.registerBuildListener("buildFinished", closure);
    }

    @Deprecated
    public void buildFinished(Action<? super BuildResult> action) {
        this.notifyListenerRegistration("Gradle.buildFinished", action);
        this.buildListenerBroadcast.add("buildFinished", action);
    }

    public void addListener(Object listener) {
        this.addListener("Gradle.addListener", listener);
    }

    public void removeListener(Object listener) {
        this.getListenerManager().removeListener(this.decorateUnknownListener(null, listener));
    }

    private void registerProjectEvaluationListener(String registrationPoint, String methodName, String signature, Action<? super Project> action) {
        this.assertProjectMutatingMethodAllowed(signature);
        this.projectEvaluationListenerBroadcast.add(methodName, this.decorate(registrationPoint, action));
    }

    private void registerProjectEvaluationListener(String registrationPoint, String methodName, String signature, Closure<?> closure) {
        this.assertProjectMutatingMethodAllowed(signature);
        this.projectEvaluationListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch(methodName, this.decorate(registrationPoint, closure)));
    }

    private void registerBuildListener(String methodName, Closure<?> closure) {
        this.buildListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch(methodName, closure));
    }

    private void registerBuildListener(String registrationPoint, String methodName, String signature, Action<? super Gradle> action) {
        this.assertProjectMutatingMethodAllowed(signature);
        this.buildListenerBroadcast.add(methodName, this.decorate(registrationPoint, action));
    }

    private void registerBuildListener(String registrationPoint, String methodName, String signature, Closure<?> closure) {
        this.assertProjectMutatingMethodAllowed(signature);
        this.buildListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch(methodName, this.decorate(registrationPoint, closure)));
    }

    private void addListener(String registrationPoint, Object listener) {
        this.notifyListenerRegistration(registrationPoint, listener);
        this.getListenerManager().addListener(this.decorateUnknownListener(registrationPoint, listener));
    }

    private void notifyListenerRegistration(String registrationPoint, Object listener) {
        if (listener instanceof InternalListener) {
            return;
        }
        this.getBuildScopeListenerRegistrationListener().onBuildScopeListenerRegistration(listener, registrationPoint, this);
    }

    private BuildScopeListenerRegistrationListener getBuildScopeListenerRegistrationListener() {
        return (BuildScopeListenerRegistrationListener)this.getListenerManager().getBroadcaster(BuildScopeListenerRegistrationListener.class);
    }

    private Object decorateUnknownListener(String registrationPoint, Object listener) {
        return this.getListenerBuildOperationDecorator().decorateUnknownListener(registrationPoint, listener);
    }

    private Closure<?> decorate(String registrationPoint, Closure<?> closure) {
        return this.getListenerBuildOperationDecorator().decorate(registrationPoint, (Closure)Cast.uncheckedNonnullCast(closure));
    }

    private <T> Action<T> decorate(String registrationPoint, Action<T> action) {
        return this.getListenerBuildOperationDecorator().decorate(registrationPoint, action);
    }

    @Deprecated
    public void useLogger(Object logger) {
        this.notifyListenerRegistration("Gradle.useLogger", logger);
        this.getListenerManager().useLogger(logger);
    }

    @Override
    public ProjectEvaluationListener getProjectEvaluationBroadcaster() {
        return (ProjectEvaluationListener)this.projectEvaluationListenerBroadcast.getSource();
    }

    public void addBuildListener(BuildListener buildListener) {
        this.addListener("Gradle.addBuildListener", buildListener);
    }

    @Override
    public BuildListener getBuildListenerBroadcaster() {
        return (BuildListener)this.buildListenerBroadcast.getSource();
    }

    public Gradle getGradle() {
        return this;
    }

    @Inject
    public abstract BuildServiceRegistry getSharedServices();

    public Collection<IncludedBuild> getIncludedBuilds() {
        return (Collection)Cast.uncheckedCast(this.includedBuilds());
    }

    @Override
    public void setIncludedBuilds(Collection<? extends IncludedBuildInternal> includedBuilds) {
        this.includedBuilds = ImmutableList.copyOf(includedBuilds);
    }

    @Override
    public List<? extends IncludedBuildInternal> includedBuilds() {
        if (this.includedBuilds == null) {
            throw new IllegalStateException("Included builds are not yet available for this build.");
        }
        return this.includedBuilds;
    }

    public IncludedBuild includedBuild(String name) {
        for (IncludedBuild includedBuild : this.includedBuilds()) {
            if (!includedBuild.getName().equals(name)) continue;
            return includedBuild;
        }
        throw new UnknownDomainObjectException("Included build '" + name + "' not found in " + this + ".");
    }

    @Override
    public ServiceRegistry getServices() {
        return this.buildScopeServices;
    }

    @Override
    protected DefaultObjectConfigurationAction createObjectConfigurationAction() {
        return new DefaultObjectConfigurationAction(this.getFileResolver(), this.getScriptPluginFactory(), this.getScriptHandlerFactory(), this.getClassLoaderScope(), this.getResourceLoaderFactory(), this);
    }

    @Override
    public void setClassLoaderScope(Supplier<? extends ClassLoaderScope> classLoaderScope) {
        if (this.classLoaderScope != null) {
            throw new IllegalStateException("Class loader scope already used");
        }
        this.classLoaderScope = classLoaderScope;
    }

    @Override
    public ClassLoaderScope getClassLoaderScope() {
        if (this.classLoaderScope == null) {
            this.classLoaderScope = () -> this.getClassLoaderScopeRegistry().getCoreAndPluginsScope();
        }
        return this.classLoaderScope.get();
    }

    @Inject
    protected abstract ClassLoaderScopeRegistry getClassLoaderScopeRegistry();

    @Override
    @Inject
    public abstract ProjectRegistry getProjectRegistry();

    @Inject
    protected abstract TextUriResourceLoader.Factory getResourceLoaderFactory();

    @Inject
    protected abstract ScriptHandlerFactory getScriptHandlerFactory();

    @Inject
    protected abstract ScriptPluginFactory getScriptPluginFactory();

    @Inject
    protected abstract FileResolver getFileResolver();

    @Inject
    protected abstract CurrentGradleInstallation getCurrentGradleInstallation();

    @Inject
    protected abstract ListenerManager getListenerManager();

    @Inject
    protected abstract ListenerBuildOperationDecorator getListenerBuildOperationDecorator();

    @Override
    @Inject
    public abstract PluginManagerInternal getPluginManager();

    @Override
    @Inject
    public abstract PublicBuildPath getPublicBuildPath();

    private DefaultGradleLifecycle instantiateGradleLifecycle() {
        return (DefaultGradleLifecycle)((ObjectFactory)this.buildScopeServices.get(ObjectFactory.class)).newInstance(DefaultGradleLifecycle.class, new Object[]{this});
    }

    static class DefaultGradleLifecycle
    implements GradleLifecycle {
        private final DefaultGradle gradle;

        @Inject
        public DefaultGradleLifecycle(DefaultGradle gradle) {
            this.gradle = gradle;
        }

        public void beforeProject(IsolatedAction<? super Project> action) {
            this.assertBeforeProjectsLoaded("beforeProject");
            this.gradle.isolatedProjectEvaluationListenerProvider.beforeProject(action);
        }

        public void afterProject(IsolatedAction<? super Project> action) {
            this.assertBeforeProjectsLoaded("afterProject");
            this.gradle.isolatedProjectEvaluationListenerProvider.afterProject(action);
        }

        private void assertBeforeProjectsLoaded(String methodName) {
            if (this.gradle.projectsLoaded) {
                throw new IllegalStateException("GradleLifecycle#" + methodName + " cannot be called after settings have been evaluated.");
            }
        }
    }
}

