/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.transfer.AccessorBackedExternalResource;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;

public class DefaultExternalResourceRepository
implements ExternalResourceRepository {
    private final String name;
    private final ExternalResourceAccessor accessor;
    private final ExternalResourceUploader uploader;
    private final ExternalResourceLister lister;

    public DefaultExternalResourceRepository(String name, ExternalResourceAccessor accessor, ExternalResourceUploader uploader, ExternalResourceLister lister) {
        this.name = name;
        this.accessor = accessor;
        this.uploader = uploader;
        this.lister = lister;
    }

    @Override
    public ExternalResourceRepository withProgressLogging() {
        return this;
    }

    @Override
    public ExternalResource resource(ExternalResourceName resource, boolean revalidate) {
        return new AccessorBackedExternalResource(resource, this.accessor, this.uploader, this.lister, revalidate);
    }

    @Override
    public ExternalResource resource(ExternalResourceName resource) {
        return this.resource(resource, false);
    }

    public String toString() {
        return this.name;
    }
}

