---
stage: none
group: Tutorials
info: For assistance with this tutorials page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
description: Planning, agile, issue boards.
title: 'Tutorials: Plan and track your work'
---

Create a project to host your code, and plan your work using
issues, epics, and more.

## Learn the fundamentals

Start here to understand planning capabilities in GitLab.

| Topic | Description | Good for beginners |
|-------|-------------|--------------------|
| [GitLab Agile Project Management](https://university.gitlab.com/courses/gitlab-agile-project-management-s2) | Learn how to use planning features to manage your projects in this self-paced course. | {{< icon name="star" >}} |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [Epics and issue boards](https://www.youtube.com/watch?v=eQUnHwbKEkY) | Find out how to use epics and issue boards for project management. | {{< icon name="star" >}} |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [Portfolio Planning - Portfolio Management](https://www.youtube.com/watch?v=d9scVJUIF4c) | Find out how manage your portfolio with requirements, issues, epics, milestones, and time tracking. | {{< icon name="star" >}} |

## Set up and manage projects

Set up your projects to manage your workflows effectively.

| Topic | Description | Good for beginners |
|-------|-------------|--------------------|
| [Set up a project for idea management](idea_management/_index.md) | Use an issue board and scoped labels to manage ideas in a team. | {{< icon name="star" >}} |
| [Set up a project for issue triage](issue_triage/_index.md) | Use labels to set up a project for issue triage. | {{< icon name="star" >}} |
| [Set up a project for issue triage](issue_triage_group/_index.md) | Use labels to set up a group with multiple projects for issue triage. | |
| [Set up a project for issue triage](issue_triage_complex_group/_index.md) | Use labels to set up a complex group with subgroups for issue triage. | |
| [Build a protected workflow for your project](protected_workflow/_index.md) | Set up a workflow for your teams, and enforce protections with approval rules. | |

## Choose your workflow

Learn how to use planning features to implement your preferred agile framework.

| Topic | Description | Good for beginners |
|-------|-------------|--------------------|
| [Use GitLab for Kanban](kanban/_index.md) | Use issue boards, scoped labels, and value stream analytics for Kanban. | {{< icon name="star" >}} |
| [Run an agile iteration](agile_sprint/_index.md) | Use group, projects, and iterations to run an agile development iteration. | |
| [Use GitLab for Scrum](scrum_events/_index.md) | Learn to run core Scrum ceremonies and workflows in GitLab. | |

## Collaborate with your team

Optimize workflows for team coordination and collaboration.

| Topic | Description | Good for beginners |
|-------|-------------|--------------------|
| [Set up issue boards for team hand-off](boards_for_teams/_index.md) | Use issue boards and scoped labels to set up collaboration across many teams. | {{< icon name="star" >}} |
| [Set up an issue board for team stand-up](boards_for_standups/_index.md) | Use issue boards and workflow labels to facilitate team stand-ups. | {{< icon name="star" >}} |
