/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.app.plugin.core.debug.service.modules.DefaultModuleMapProposal;
import ghidra.app.plugin.core.debug.service.modules.DefaultRegionMapProposal;
import ghidra.app.plugin.core.debug.service.modules.DefaultSectionMapProposal;
import ghidra.app.plugin.core.debug.service.modules.PeekOpenedDomainObject;
import ghidra.app.plugin.core.debug.service.modules.ProgramModuleIndexer;
import ghidra.debug.api.modules.MapProposal;
import ghidra.debug.api.modules.ModuleMapProposal;
import ghidra.debug.api.modules.RegionMapProposal;
import ghidra.debug.api.modules.SectionMapProposal;
import ghidra.framework.model.DomainFile;
import ghidra.graph.DefaultGEdge;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.jung.JungDirectedGraph;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.util.Msg;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DebuggerStaticMappingProposals
extends Enum<DebuggerStaticMappingProposals> {
    private static final /* synthetic */ DebuggerStaticMappingProposals[] $VALUES;

    public static DebuggerStaticMappingProposals[] values() {
        return (DebuggerStaticMappingProposals[])$VALUES.clone();
    }

    public static DebuggerStaticMappingProposals valueOf(String name) {
        return Enum.valueOf(DebuggerStaticMappingProposals.class, name);
    }

    protected static String getLastLower(String path) {
        return new File(path).getName().toLowerCase();
    }

    protected static boolean namesContain(Program program, String moduleLowerName) {
        String execName;
        DomainFile df = program.getDomainFile();
        if (df == null || df.getProjectLocator() == null) {
            return false;
        }
        String programName = DebuggerStaticMappingProposals.getLastLower(program.getName());
        if (programName.contains(moduleLowerName)) {
            return true;
        }
        String exePath = program.getExecutablePath();
        if (exePath != null && (execName = DebuggerStaticMappingProposals.getLastLower(exePath)).contains(moduleLowerName)) {
            return true;
        }
        String fileName = df.getName().toLowerCase();
        return fileName.contains(moduleLowerName);
    }

    public static RegionMapProposal proposeRegionMap(Collection<? extends TraceMemoryRegion> regions, long snap, Collection<? extends Program> programs) {
        return (RegionMapProposal)new RegionMapProposalGenerator(snap).proposeBestMap(Collections.unmodifiableCollection(regions), programs);
    }

    public static <V, J> Set<Set<V>> groupByComponents(Collection<? extends V> vertices, Function<V, J> precompute, BiPredicate<J, J> areConnected) {
        List<V> vs = List.copyOf(vertices);
        List pres = vs.stream().map(precompute).collect(Collectors.toList());
        JungDirectedGraph graph = new JungDirectedGraph();
        for (V v : vs) {
            graph.addVertex(v);
        }
        int size = vs.size();
        for (int i = 0; i < size; ++i) {
            V v1 = vs.get(i);
            Object j1 = pres.get(i);
            for (int j = i + 1; j < size; ++j) {
                V v2 = vs.get(j);
                Object j2 = pres.get(j);
                if (!areConnected.test(j1, j2)) continue;
                graph.addEdge((GEdge)new DefaultGEdge(v1, v2));
                graph.addEdge((GEdge)new DefaultGEdge(v2, v1));
            }
        }
        return GraphAlgorithms.getStronglyConnectedComponents((GDirectedGraph)graph);
    }

    protected static Set<String> getLikelyModulesFromName(TraceMemoryRegion region) {
        String key;
        try {
            KeyPath path = KeyPath.parse((String)region.getPath());
            key = KeyPath.parseIfIndex((String)path.key());
        }
        catch (IllegalArgumentException e) {
            Msg.error(DebuggerStaticMappingProposals.class, (Object)("Encountered unparsable path: " + region.getPath()));
            key = region.getName(0L);
        }
        return Stream.of(key.split("\\s+")).filter(n -> n.replaceAll("[0-9A-Fa-f]+", "").length() >= 5).collect(Collectors.toSet());
    }

    public static Set<Set<TraceMemoryRegion>> groupRegionsByLikelyModule(Collection<? extends TraceMemoryRegion> regions) {
        return DebuggerStaticMappingProposals.groupByComponents(regions, r -> DebuggerStaticMappingProposals.getLikelyModulesFromName(r), (m1, m2) -> m1.stream().anyMatch(m2::contains));
    }

    private static /* synthetic */ DebuggerStaticMappingProposals[] $values() {
        return new DebuggerStaticMappingProposals[0];
    }

    static {
        $VALUES = DebuggerStaticMappingProposals.$values();
    }

    public static class RegionMapProposalGenerator
    extends AbstractProposalGenerator<Collection<TraceMemoryRegion>, Program, Set<String>, RegionMapProposal> {
        public RegionMapProposalGenerator(long snap) {
            super(snap);
        }

        @Override
        protected RegionMapProposal proposeMap(Collection<TraceMemoryRegion> from, Program to) {
            return new DefaultRegionMapProposal(from, this.snap, to);
        }

        @Override
        protected Set<String> computeFromJoinKey(Collection<TraceMemoryRegion> from) {
            return from.stream().flatMap(r -> DebuggerStaticMappingProposals.getLikelyModulesFromName(r).stream()).map(n -> DebuggerStaticMappingProposals.getLastLower(n)).collect(Collectors.toSet());
        }

        @Override
        protected boolean isJoined(Set<String> key, Program to) {
            return key.stream().anyMatch(n -> DebuggerStaticMappingProposals.namesContain(to, n));
        }
    }

    public static class SectionMapProposalGenerator
    extends AbstractProposalGenerator<TraceModule, Program, String, SectionMapProposal> {
        public SectionMapProposalGenerator(long snap) {
            super(snap);
        }

        @Override
        protected SectionMapProposal proposeMap(TraceModule from, Program to) {
            return new DefaultSectionMapProposal(from, this.snap, to);
        }

        @Override
        protected String computeFromJoinKey(TraceModule from) {
            return DebuggerStaticMappingProposals.getLastLower(from.getName(this.snap));
        }

        @Override
        protected boolean isJoined(String key, Program to) {
            return DebuggerStaticMappingProposals.namesContain(to, key);
        }
    }

    protected static class ModuleMapProposalGenerator
    implements ProposalGenerator<TraceModule, Program, ModuleMapProposal> {
        private final ProgramModuleIndexer indexer;

        public ModuleMapProposalGenerator(ProgramModuleIndexer indexer) {
            this.indexer = indexer;
        }

        @Override
        public ModuleMapProposal proposeMap(TraceModule from, long snap, Program to) {
            return new DefaultModuleMapProposal(from, snap, to);
        }

        @Override
        public ModuleMapProposal proposeBestMap(TraceModule from, long snap, Collection<? extends Program> tos) {
            Collection<ProgramModuleIndexer.IndexEntry> entries = this.indexer.filter(this.indexer.getBestEntries(from, snap), tos);
            DomainFile df = this.indexer.getBestMatch(from, snap, null, entries);
            if (df == null) {
                return null;
            }
            try (PeekOpenedDomainObject peek = new PeekOpenedDomainObject(df);){
                ModuleMapProposal moduleMapProposal = this.proposeMap(from, snap, (Program)peek.object);
                return moduleMapProposal;
            }
        }

        @Override
        public Map<TraceModule, ModuleMapProposal> proposeBestMaps(Collection<? extends TraceModule> froms, long snap, Collection<? extends Program> tos) {
            LinkedHashMap<TraceModule, ModuleMapProposal> result = new LinkedHashMap<TraceModule, ModuleMapProposal>();
            for (TraceModule traceModule : froms) {
                ModuleMapProposal map = this.proposeBestMap(traceModule, snap, tos);
                if (map == null) continue;
                result.put(traceModule, map);
            }
            return result;
        }
    }

    protected static abstract class AbstractProposalGenerator<F, T, J, MP extends MapProposal<?, ?, ?>> {
        protected final long snap;

        public AbstractProposalGenerator(long snap) {
            this.snap = snap;
        }

        protected abstract MP proposeMap(F var1, T var2);

        protected abstract J computeFromJoinKey(F var1);

        protected abstract boolean isJoined(J var1, T var2);

        protected Collection<T> filterJoined(J key, Collection<? extends T> tos) {
            return tos.stream().filter(t -> this.isJoined(key, t)).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        protected MP proposeBestMap(F from, Collection<? extends T> tos) {
            double bestScore = -1.0;
            MP bestMap = null;
            for (T t : tos) {
                MP map = this.proposeMap(from, t);
                double score = map.computeScore();
                if (!(score > bestScore)) continue;
                bestScore = score;
                bestMap = map;
            }
            return bestMap;
        }

        protected Map<F, MP> proposeBestMaps(Collection<? extends F> froms, Collection<? extends T> tos) {
            LinkedHashMap<F, MP> result = new LinkedHashMap<F, MP>();
            for (F f : froms) {
                J joinKey;
                Collection<? extends T> joined;
                MP map = this.proposeBestMap(f, joined = this.filterJoined(joinKey = this.computeFromJoinKey(f), tos));
                if (map == null) continue;
                result.put(f, map);
            }
            return result;
        }
    }

    protected static interface ProposalGenerator<F, T, MP extends MapProposal<?, ?, ?>> {
        public MP proposeMap(F var1, long var2, T var4);

        public MP proposeBestMap(F var1, long var2, Collection<? extends T> var4);

        public Map<F, MP> proposeBestMaps(Collection<? extends F> var1, long var2, Collection<? extends T> var4);
    }
}

