/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net.http;

import ghidra.net.DefaultKeyManagerFactory;
import ghidra.util.Msg;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class HttpUtil {
    public static HttpURLConnection getContent(String httpUrlString, Properties httpRequestProperties, boolean allowRedirect) throws MalformedURLException, IOException {
        int rc;
        URL url = new URL(httpUrlString);
        String protocol = url.getProtocol();
        if ("https".equals(protocol)) {
            if (!DefaultKeyManagerFactory.initialize() && DefaultKeyManagerFactory.getKeyStore() != null) {
                throw new IOException("Failed to initialize PKI certificate keystore");
            }
        } else if (!"http".equals(protocol)) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        HttpURLConnection c = (HttpURLConnection)url.openConnection();
        if (allowRedirect) {
            c.setInstanceFollowRedirects(true);
        }
        c.setRequestMethod("GET");
        if (httpRequestProperties != null) {
            for (String name : httpRequestProperties.stringPropertyNames()) {
                c.setRequestProperty(name, httpRequestProperties.getProperty(name));
            }
        }
        if ((rc = c.getResponseCode()) != 200) {
            throw new IOException(c.getResponseMessage());
        }
        Msg.info(HttpUtil.class, (Object)("Get URL content: " + String.valueOf(url)));
        if (!url.equals(c.getURL())) {
            Msg.info(HttpUtil.class, (Object)("Actual URL: " + String.valueOf(c.getURL())));
        }
        Msg.info(HttpUtil.class, (Object)(" > Content-Type=" + c.getHeaderField("Content-Type")));
        String contentLengthStr = c.getHeaderField("Content-Length");
        if (contentLengthStr == null) {
            c.disconnect();
            String encodingStr = c.getHeaderField("Transfer-Encoding");
            if (encodingStr != null) {
                throw new IOException("Unsupport HTTP transfer encoding: " + encodingStr);
            }
            throw new IOException("Unsupported HTTP transfer (Content-Length not specified)");
        }
        Msg.info(HttpUtil.class, (Object)(" > Content-Length=" + contentLengthStr));
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFile(String httpUrlString, Properties httpRequestProperties, boolean allowRedirect, File destFile) throws MalformedURLException, IOException {
        HttpURLConnection connection = null;
        try (InputStream content = null;){
            connection = HttpUtil.getContent(httpUrlString, httpRequestProperties, allowRedirect);
            content = connection.getInputStream();
            byte[] dataBuffer = new byte[8192];
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));){
                int len;
                while ((len = content.read(dataBuffer)) >= 0) {
                    out.write(dataBuffer, 0, len);
                }
            }
        }
        return connection.getContentType();
    }
}

