/*
 * Decompiled with CFR 0.152.
 */
package ghidra.taint.model;

import ghidra.taint.model.TaintMark;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaintSet {
    private static final String SEP = ";";
    public static final TaintSet EMPTY = new TaintSet(Set.of());
    final Set<TaintMark> marks;
    private final int hashCode;

    public static TaintSet parse(String string) {
        return new TaintSet(Stream.of(string.split(SEP)).map(TaintMark::parse).collect(Collectors.toUnmodifiableSet()));
    }

    public static TaintSet of(TaintMark ... marks) {
        return new TaintSet(Set.of(marks));
    }

    static TaintSet of(Set<TaintMark> marks) {
        return new TaintSet(Set.copyOf(marks));
    }

    TaintSet(Set<TaintMark> marks) {
        this.marks = marks;
        this.hashCode = Objects.hashCode(marks);
    }

    public String toString() {
        return this.marks.stream().map(TaintMark::toString).collect(Collectors.joining(SEP));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaintSet)) {
            return false;
        }
        TaintSet that = (TaintSet)obj;
        return Objects.equals(this.marks, that.marks);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Set<TaintMark> getMarks() {
        return this.marks;
    }

    public boolean isEmpty() {
        return this.marks.isEmpty();
    }

    public TaintSet union(TaintSet that) {
        HashSet<TaintMark> marks = new HashSet<TaintMark>();
        marks.addAll(this.marks);
        marks.addAll(that.marks);
        return TaintSet.of(marks);
    }

    public TaintSet tagged(String string) {
        int size = this.marks.size();
        HashSet<TaintMark> marks = new HashSet<TaintMark>(size);
        for (TaintMark m : this.marks) {
            marks.add(m.tagged(string));
        }
        return TaintSet.of(marks);
    }
}

