/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.microsoft;

import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.Demangler;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.MangledContext;
import ghidra.app.util.demangler.microsoft.MicrosoftDemanglerOptions;
import ghidra.app.util.demangler.microsoft.MicrosoftDemanglerUtil;
import ghidra.app.util.demangler.microsoft.MicrosoftMangledContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import mdemangler.MDException;
import mdemangler.MDMangGhidra;
import mdemangler.MDParsableItem;
import mdemangler.datatype.MDDataType;

public class MicrosoftDemangler
implements Demangler {
    private MDMangGhidra demangler;
    private MDParsableItem item;
    private DemangledObject object;
    private MDDataType mdType;
    private DemangledDataType dataType;

    public boolean canDemangle(Program program) {
        String executableFormat = program.getExecutableFormat();
        return executableFormat != null && (executableFormat.indexOf("Portable Executable (PE)") != -1 || executableFormat.indexOf("MS Common Object File Format (COFF)") != -1);
    }

    public DemangledObject demangle(MangledContext context) throws DemangledException {
        if (!(context instanceof MicrosoftMangledContext)) {
            throw new DemangledException("Wrong context type");
        }
        MicrosoftMangledContext mContext = (MicrosoftMangledContext)context;
        DemanglerOptions demanglerOptions = context.getOptions();
        if (!(demanglerOptions instanceof MicrosoftDemanglerOptions)) {
            throw new DemangledException("MicrosoftDemanglerOptions expected");
        }
        MicrosoftDemanglerOptions options = (MicrosoftDemanglerOptions)demanglerOptions;
        String mangled = context.getMangled();
        this.demangler = new MDMangGhidra();
        this.demangler.setMangledSymbol(mangled);
        this.demangler.setErrorOnRemainingChars(options.errorOnRemainingChars());
        this.demangler.setDemangleOnlyKnownPatterns(options.demangleOnlyKnownPatterns());
        this.demangler.setArchitectureSize(mContext.getArchitectureSize());
        this.demangler.setIsFunction(mContext.shouldInterpretAsFunction());
        try {
            this.item = this.demangler.demangle();
            if (this.item == null) {
                return null;
            }
            String originalDemangled = this.item.toString();
            this.demangler.getOutputOptions().setUseEncodedAnonymousNamespace(true);
            this.object = MicrosoftDemanglerUtil.convertToDemangledObject(this.item, mangled, originalDemangled);
            if (this.object != null) {
                this.object.setMangledContext(context);
            }
            return this.object;
        }
        catch (MDException e) {
            DemangledException de = new DemangledException(true);
            de.initCause((Throwable)e);
            throw de;
        }
    }

    public DemangledDataType demangleType(MangledContext context) throws DemangledException {
        if (!(context instanceof MicrosoftMangledContext)) {
            throw new DemangledException("Wrong context type");
        }
        MicrosoftMangledContext mContext = (MicrosoftMangledContext)context;
        DemanglerOptions demanglerOptions = context.getOptions();
        if (!(demanglerOptions instanceof MicrosoftDemanglerOptions)) {
            throw new DemangledException("MicrosoftDemanglerOptions expected");
        }
        MicrosoftDemanglerOptions options = (MicrosoftDemanglerOptions)demanglerOptions;
        String mangled = context.getMangled();
        this.demangler = new MDMangGhidra();
        this.demangler.setMangledSymbol(mangled);
        this.demangler.setErrorOnRemainingChars(options.errorOnRemainingChars());
        this.demangler.setDemangleOnlyKnownPatterns(options.demangleOnlyKnownPatterns());
        this.demangler.setArchitectureSize(mContext.getArchitectureSize());
        this.demangler.setIsFunction(mContext.shouldInterpretAsFunction());
        try {
            this.mdType = this.demangler.demangleType();
            if (this.mdType == null) {
                return null;
            }
            String originalDemangled = this.mdType.toString();
            this.demangler.getOutputOptions().setUseEncodedAnonymousNamespace(true);
            this.dataType = MicrosoftDemanglerUtil.convertToDemangledDataType(this.mdType, mangled, originalDemangled);
            if (this.dataType != null) {
                this.dataType.setMangledContext(context);
            }
            return this.dataType;
        }
        catch (MDException e) {
            DemangledException de = new DemangledException(true);
            de.initCause((Throwable)e);
            throw de;
        }
    }

    public MDParsableItem getMdItem() {
        return this.item;
    }

    public MDDataType getMdType() {
        return this.mdType;
    }

    public MicrosoftDemanglerOptions createDefaultOptions() {
        return new MicrosoftDemanglerOptions();
    }

    public MicrosoftMangledContext createMangledContext(String mangled, DemanglerOptions options, Program program, Address address) {
        return new MicrosoftMangledContext(program, this.getMicrosoftOptions(options), mangled, address);
    }

    private MicrosoftDemanglerOptions getMicrosoftOptions(DemanglerOptions options) {
        if (options instanceof MicrosoftDemanglerOptions) {
            MicrosoftDemanglerOptions mOptions = (MicrosoftDemanglerOptions)options;
            return mOptions;
        }
        if (options == null) {
            return this.createDefaultOptions();
        }
        return new MicrosoftDemanglerOptions(options);
    }
}

