/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

public enum PdbKind {
    STRUCTURE,
    UNION,
    MEMBER,
    STATIC_LOCAL,
    STATIC_MEMBER,
    OBJECT_POINTER,
    PARAMETER,
    LOCAL,
    UNKNOWN;

    private final String camelName = PdbKind.toCamel(this.name());

    public String getCamelName() {
        return this.camelName;
    }

    private static String toCamel(String name) {
        StringBuilder buf = new StringBuilder();
        boolean makeUpper = true;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                makeUpper = true;
                continue;
            }
            if (makeUpper) {
                c = Character.toUpperCase(c);
                makeUpper = false;
            } else {
                c = Character.toLowerCase(c);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static PdbKind parse(String kind) {
        for (PdbKind pdbKind : PdbKind.values()) {
            if (!pdbKind.camelName.equalsIgnoreCase(kind)) continue;
            return pdbKind;
        }
        return UNKNOWN;
    }
}

