/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.options.editor.FontPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyEditorSupport;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FontEditor
extends PropertyEditorSupport {
    private JButton previewButton = new JButton("ABCabc \u00a9\u00ab\u00a7\u0429\u05d1\u062c\u4eb9");
    private FontPropertyEditor fontPropertyEditor;

    public FontEditor() {
        this.previewButton.getAccessibleContext().setAccessibleName("Preview");
        this.previewButton.addActionListener(e -> this.buttonPushed());
        this.fontPropertyEditor = new FontPropertyEditor();
        this.fontPropertyEditor.addPropertyChangeListener(ev -> this.fontChanged());
    }

    private void buttonPushed() {
        this.showDialog();
        this.previewButton.setFont((Font)this.getValue());
    }

    public void showDialog() {
        EditorDialogProvider provider = new EditorDialogProvider();
        DockingWindowManager.showDialog(this.previewButton, provider);
        this.previewButton.repaint();
    }

    @Override
    public void setValue(Object o) {
        if (Objects.equals(o, this.getValue())) {
            return;
        }
        Font font = (Font)o;
        this.previewButton.setFont(font);
        this.fontPropertyEditor.setValue(font);
        super.setValue(font);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.previewButton;
    }

    private void fontChanged() {
        Font font = (Font)this.fontPropertyEditor.getValue();
        this.setValue(font);
    }

    private class EditorDialogProvider
    extends DialogComponentProvider {
        private Font originalFont;

        EditorDialogProvider() {
            super("Font Editor", true);
            this.originalFont = (Font)FontEditor.this.getValue();
            this.addWorkPanel(this.buildWorkPanel());
            this.addOKButton();
            this.addCancelButton();
        }

        private JComponent buildWorkPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(FontEditor.this.fontPropertyEditor.getCustomEditor());
            panel.getAccessibleContext().setAccessibleName("Font Editor");
            return panel;
        }

        @Override
        protected void okCallback() {
            this.close();
        }

        @Override
        protected void cancelCallback() {
            FontEditor.this.setValue(this.originalFont);
            this.close();
        }
    }
}

