/*
 * Decompiled with CFR 0.152.
 */
package docking.dnd;

import docking.dnd.DragDropTableSelectionMouseListener;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListSelectionModel;

public abstract class GTableDragProvider<ROW_OBJECT>
implements DragSourceListener,
DragGestureListener {
    protected GTable table;
    protected RowObjectTableModel<ROW_OBJECT> rowObjectModel;

    public GTableDragProvider(GTable table, RowObjectTableModel<ROW_OBJECT> model) {
        this.table = table;
        this.rowObjectModel = model;
        new DragDropTableSelectionMouseListener(table);
        int actions = 1;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(table, actions, this);
    }

    protected abstract Transferable createDragTransferable(List<ROW_OBJECT> var1);

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        this.setCursor(0, dse.getDragSourceContext());
    }

    private void setCursor(int action, DragSourceContext dragSourceContext) {
        Cursor cursor = DragSource.DefaultCopyNoDrop;
        switch (action) {
            case 1: {
                cursor = DragSource.DefaultCopyDrop;
                break;
            }
            case 2: {
                cursor = DragSource.DefaultMoveDrop;
                break;
            }
            case 0x40000000: {
                cursor = DragSource.DefaultLinkDrop;
            }
        }
        dragSourceContext.setCursor(cursor);
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        this.setCursor(dsde.getDropAction(), dsde.getDragSourceContext());
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragEvent) {
        InputEvent ie = dragEvent.getTriggerEvent();
        int modifiers = ie.getModifiersEx();
        if ((modifiers & 0x800) != 0 || (modifiers & 0x1000) != 0) {
            return;
        }
        List<ROW_OBJECT> items = this.getSelectedItems();
        if (items.isEmpty()) {
            return;
        }
        Transferable transferable = this.createDragTransferable(items);
        if (transferable == null) {
            return;
        }
        try {
            dragEvent.startDrag(DragSource.DefaultMoveDrop, null, new Point(0, 0), transferable, this);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            // empty catch block
        }
    }

    protected List<ROW_OBJECT> getSelectedItems() {
        ListSelectionModel lsm = this.table.getSelectionModel();
        if (lsm.getValueIsAdjusting()) {
            return Collections.emptyList();
        }
        int[] rows = this.table.getSelectedRows();
        ArrayList<ROW_OBJECT> objects = new ArrayList<ROW_OBJECT>();
        for (int row : rows) {
            ROW_OBJECT ro = this.rowObjectModel.getRowObject(row);
            objects.add(ro);
        }
        return objects;
    }
}

