/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target.schema;

import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.info.TraceObjectInterfaceUtils;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DefaultTraceObjectSchema
implements TraceObjectSchema,
Comparable<DefaultTraceObjectSchema> {
    private static final String INDENT = "  ";
    private final SchemaContext context;
    private final TraceObjectSchema.SchemaName name;
    private final Class<?> type;
    private final Set<Class<? extends TraceObjectInterface>> interfaces;
    private final boolean isCanonicalContainer;
    private final Map<String, TraceObjectSchema.SchemaName> elementSchemas;
    private final TraceObjectSchema.SchemaName defaultElementSchema;
    private final Map<String, TraceObjectSchema.AttributeSchema> attributeSchemas;
    private final Map<String, String> attributeAliases;
    private final TraceObjectSchema.AttributeSchema defaultAttributeSchema;

    DefaultTraceObjectSchema(SchemaContext context, TraceObjectSchema.SchemaName name, Class<?> type, Set<Class<? extends TraceObjectInterface>> interfaces, boolean isCanonicalContainer, Map<String, TraceObjectSchema.SchemaName> elementSchemas, TraceObjectSchema.SchemaName defaultElementSchema, Map<String, TraceObjectSchema.AttributeSchema> attributeSchemas, Map<String, String> attributeAliases, TraceObjectSchema.AttributeSchema defaultAttributeSchema) {
        this.context = context;
        this.name = name;
        this.type = type;
        this.interfaces = Collections.unmodifiableSet(new LinkedHashSet<Class<? extends TraceObjectInterface>>(interfaces));
        this.isCanonicalContainer = isCanonicalContainer;
        this.elementSchemas = Collections.unmodifiableMap(new LinkedHashMap<String, TraceObjectSchema.SchemaName>(elementSchemas));
        this.defaultElementSchema = defaultElementSchema;
        AliasResolver resolver = new AliasResolver(attributeSchemas, attributeAliases, defaultAttributeSchema);
        this.attributeAliases = Collections.unmodifiableMap(resolver.resolveAliases());
        this.attributeSchemas = Collections.unmodifiableMap(resolver.resolveSchemas());
        this.defaultAttributeSchema = defaultAttributeSchema;
    }

    @Override
    public SchemaContext getContext() {
        return this.context;
    }

    @Override
    public TraceObjectSchema.SchemaName getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Set<Class<? extends TraceObjectInterface>> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public boolean isCanonicalContainer() {
        return this.isCanonicalContainer;
    }

    @Override
    public Map<String, TraceObjectSchema.SchemaName> getElementSchemas() {
        return this.elementSchemas;
    }

    @Override
    public TraceObjectSchema.SchemaName getDefaultElementSchema() {
        return this.defaultElementSchema;
    }

    @Override
    public Map<String, TraceObjectSchema.AttributeSchema> getAttributeSchemas() {
        return this.attributeSchemas;
    }

    @Override
    public Map<String, String> getAttributeAliases() {
        return this.attributeAliases;
    }

    @Override
    public TraceObjectSchema.AttributeSchema getDefaultAttributeSchema() {
        return this.defaultAttributeSchema;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
        sb.append("schema ");
        sb.append(this.name);
        if (this.isCanonicalContainer) {
            sb.append("*");
        }
        sb.append(" {\n  ");
        sb.append("ifaces = [");
        for (Class<? extends TraceObjectInterface> iface : this.interfaces) {
            sb.append(TraceObjectInterfaceUtils.getSchemaName(iface));
            sb.append(" ");
        }
        sb.append("]\n  ");
        sb.append("elements = ");
        sb.append(this.elementSchemas);
        sb.append(" default " + String.valueOf(this.defaultElementSchema));
        sb.append("\n  ");
        sb.append("attributes = ");
        sb.append(this.attributeSchemas);
        sb.append(" default " + String.valueOf(this.defaultAttributeSchema));
        sb.append(" aliases " + String.valueOf(this.attributeAliases));
        sb.append("\n}");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultTraceObjectSchema)) {
            return false;
        }
        DefaultTraceObjectSchema that = (DefaultTraceObjectSchema)obj;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.interfaces, that.interfaces)) {
            return false;
        }
        if (this.isCanonicalContainer != that.isCanonicalContainer) {
            return false;
        }
        if (!Objects.equals(this.elementSchemas, that.elementSchemas)) {
            return false;
        }
        if (!Objects.equals(this.defaultElementSchema, that.defaultElementSchema)) {
            return false;
        }
        if (!Objects.equals(this.attributeSchemas, that.attributeSchemas)) {
            return false;
        }
        if (!Objects.equals(this.attributeAliases, that.attributeAliases)) {
            return false;
        }
        return Objects.equals(this.defaultAttributeSchema, that.defaultAttributeSchema);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(DefaultTraceObjectSchema o) {
        return this.name.compareTo(o.name);
    }

    protected static class AliasResolver {
        private final Map<String, TraceObjectSchema.AttributeSchema> schemas;
        private final Map<String, String> aliases;
        private final TraceObjectSchema.AttributeSchema defaultSchema;
        private Map<String, String> resolvedAliases;

        public AliasResolver(Map<String, TraceObjectSchema.AttributeSchema> schemas, Map<String, String> aliases, TraceObjectSchema.AttributeSchema defaultSchema) {
            this.schemas = schemas;
            this.aliases = aliases;
            this.defaultSchema = defaultSchema;
        }

        public Map<String, String> resolveAliases() {
            this.resolvedAliases = new LinkedHashMap<String, String>();
            for (String alias : this.aliases.keySet()) {
                if (alias.equals("")) {
                    throw new IllegalArgumentException("Key '' cannot be an alias");
                }
                if (this.schemas.containsKey(alias)) {
                    throw new IllegalArgumentException("Key '%s' cannot be both an attribute and an alias".formatted(alias));
                }
                this.resolveAlias(alias, new LinkedHashSet<String>());
            }
            return this.resolvedAliases;
        }

        protected String resolveAlias(String alias, LinkedHashSet<String> visited) {
            String already = this.resolvedAliases.get(alias);
            if (already != null) {
                return already;
            }
            if (!visited.add(alias)) {
                throw new IllegalArgumentException("Cycle of aliases: " + String.valueOf(visited));
            }
            String to = this.aliases.get(alias);
            if (to == null) {
                return alias;
            }
            if (to.equals("")) {
                throw new IllegalArgumentException("Cannot alias to key '' (from %s)".formatted(alias));
            }
            String result = this.resolveAlias(to, visited);
            this.resolvedAliases.put(alias, result);
            return result;
        }

        public Map<String, TraceObjectSchema.AttributeSchema> resolveSchemas() {
            LinkedHashMap<String, TraceObjectSchema.AttributeSchema> resolved = new LinkedHashMap<String, TraceObjectSchema.AttributeSchema>(this.schemas);
            for (Map.Entry<String, String> ent : this.resolvedAliases.entrySet()) {
                resolved.put(ent.getKey(), this.schemas.getOrDefault(ent.getValue(), this.defaultSchema));
            }
            return resolved;
        }
    }

    public static class DefaultAttributeSchema
    implements TraceObjectSchema.AttributeSchema,
    Comparable<DefaultAttributeSchema> {
        private final String name;
        private final TraceObjectSchema.SchemaName schema;
        private final boolean isRequired;
        private final boolean isFixed;
        private final TraceObjectSchema.Hidden hidden;

        public DefaultAttributeSchema(String name, TraceObjectSchema.SchemaName schema, boolean isRequired, boolean isFixed, TraceObjectSchema.Hidden hidden) {
            if (name.equals("") && isRequired) {
                throw new IllegalArgumentException("The default attribute schema cannot be required");
            }
            this.name = name;
            this.schema = schema;
            this.isRequired = isRequired;
            this.isFixed = isFixed;
            this.hidden = hidden.adjust(name);
        }

        public String toString() {
            return String.format("<attr name=%s schema=%s required=%s fixed=%s hidden=%s>", this.name, this.schema, this.isRequired, this.isFixed, this.hidden.toString().toLowerCase());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DefaultAttributeSchema)) {
                return false;
            }
            DefaultAttributeSchema that = (DefaultAttributeSchema)obj;
            if (!Objects.equals(this.name, that.name)) {
                return false;
            }
            if (!Objects.equals(this.schema, that.schema)) {
                return false;
            }
            if (this.isRequired != that.isRequired) {
                return false;
            }
            if (this.isFixed != that.isFixed) {
                return false;
            }
            return this.hidden == that.hidden;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(DefaultAttributeSchema o) {
            return this.name.compareTo(o.name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TraceObjectSchema.SchemaName getSchema() {
            return this.schema;
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public boolean isFixed() {
            return this.isFixed;
        }

        @Override
        public TraceObjectSchema.Hidden getHidden() {
            return this.hidden;
        }
    }
}

