/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.DecompileDebugFormatManager;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DecompileDebugXmlLoader
extends AbstractProgramLoader {
    public static final String DECOMPILER_DEBUG_SRC_NAME = "Decompiler Debug XML";

    @Override
    public String getName() {
        return DECOMPILER_DEBUG_SRC_NAME;
    }

    @Override
    public LoaderTier getTier() {
        return LoaderTier.SPECIALIZED_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 50;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        this.getLanguageService();
        ParseGhidraDebugResult result = this.parse(provider);
        DecompileDebugProgramInfo info = result.lastInfo;
        if (info == null) {
            return loadSpecs;
        }
        LanguageID languageID = new LanguageID(info.specString());
        LanguageDescription languageDescription = this.getLanguageService().getLanguageDescription(languageID);
        for (CompilerSpecDescription csd : languageDescription.getCompatibleCompilerSpecDescriptions()) {
            LanguageCompilerSpecPair pair = new LanguageCompilerSpecPair(languageDescription.getLanguageID(), csd.getCompilerSpecID());
            if (!info.compilerString().equals(csd.getCompilerSpecID().getIdAsString())) continue;
            loadSpecs.add(new LoadSpec(this, 0L, pair, true));
        }
        return loadSpecs;
    }

    @Override
    protected List<Loaded<Program>> loadProgram(Loader.ImporterSettings settings) throws IOException, CancelledException {
        LanguageCompilerSpecPair pair = settings.loadSpec().getLanguageCompilerSpec();
        Language importerLanguage = this.getLanguageService().getLanguage(pair.languageID);
        ParseGhidraDebugResult parsedResult = this.parse(settings.provider());
        if (parsedResult.lastInfo == null) {
            return new ArrayList<Loaded<Program>>();
        }
        Address imageBase = null;
        if (parsedResult.lastInfo.offset() != null) {
            imageBase = importerLanguage.getAddressFactory().getAddress(parsedResult.lastInfo.offset());
        }
        Program prog = this.createProgram(imageBase, settings);
        List<Loaded<Program>> loadedList = List.of(new Loaded<Program>(prog, settings));
        int loadingId = prog.startTransaction("Loading debug XML file");
        try {
            this.doImport(parsedResult.debugXmlMgr, settings.options(), settings.log(), prog, settings.monitor(), false, settings.importName());
        }
        catch (IllegalArgumentException e) {
            throw new LoadException("Failed to load");
        }
        finally {
            prog.endTransaction(loadingId, true);
        }
        return loadedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doImport(final DecompileDebugFormatManager debugXmlMgr, final List<Option> options, final MessageLog log, Program prog, TaskMonitor monitor, final boolean isAddToProgram, final String programName) throws IOException {
        if (!AutoAnalysisManager.hasAutoAnalysisManager(prog)) {
            int txId = prog.startTransaction("Decompiler Debug XML Import");
            try {
                boolean bl = this.doImportWork(debugXmlMgr, options, log, prog, monitor, isAddToProgram, programName);
                return bl;
            }
            finally {
                prog.endTransaction(txId, true);
            }
        }
        AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager(prog);
        try {
            return analysisMgr.scheduleWorker(new AnalysisWorker(){

                @Override
                public String getWorkerName() {
                    return "Decompiler Debug XML Importer";
                }

                @Override
                public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor taskMonitor) throws Exception, CancelledException {
                    return DecompileDebugXmlLoader.this.doImportWork(debugXmlMgr, options, log, program, taskMonitor, isAddToProgram, programName);
                }
            }, null, false, monitor);
        }
        catch (CancelledException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean doImportWork(DecompileDebugFormatManager debugXmlMgr, List<Option> options, MessageLog log, Program prog, TaskMonitor monitor, boolean isAddToProgram, String programName) throws LoadException {
        MessageLog mgrLog = null;
        boolean success = false;
        try {
            mgrLog = debugXmlMgr.read(prog, monitor, programName);
            log.copyFrom(mgrLog);
            success = true;
        }
        catch (Exception e) {
            String message = "";
            if (mgrLog != null && !"".equals(mgrLog.toString())) {
                message = mgrLog.toString();
            }
            if (log != null && !"".equals(log.toString())) {
                message = log.toString();
            }
            Msg.warn((Object)this, (Object)("XML import exception, log: " + message), (Throwable)e);
            throw new LoadException(e.getMessage());
        }
        return success;
    }

    private ParseGhidraDebugResult parse(ByteProvider provider) {
        try {
            DecompileDebugFormatManager debugXmlMgr = new DecompileDebugFormatManager(provider);
            DecompileDebugProgramInfo decompileProgInfo = debugXmlMgr.getProgramInfo();
            return new ParseGhidraDebugResult(debugXmlMgr, decompileProgInfo);
        }
        catch (Throwable e) {
            Msg.trace((Object)this, (Object)("Unable to parse the Ghidra Decompiler XML for " + provider.getName()), (Throwable)e);
            return new ParseGhidraDebugResult(null, null);
        }
    }

    @Override
    protected void loadProgramInto(Program program, Loader.ImporterSettings settings) throws IOException, LoadException, CancelledException {
    }

    private static class ParseGhidraDebugResult {
        final DecompileDebugFormatManager debugXmlMgr;
        final DecompileDebugProgramInfo lastInfo;

        ParseGhidraDebugResult(DecompileDebugFormatManager debugXmlMgr, DecompileDebugProgramInfo lastInfo) {
            this.debugXmlMgr = debugXmlMgr;
            this.lastInfo = lastInfo;
        }
    }

    record DecompileDebugProgramInfo(String offset, String compilerString, String specString) {
    }
}

