/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.OffsetValidator;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbolsHeader;
import ghidra.app.util.bin.format.pe.debug.DebugCodeView;
import ghidra.app.util.bin.format.pe.debug.DebugDirectory;
import ghidra.app.util.bin.format.pe.debug.DebugFixup;
import ghidra.app.util.bin.format.pe.debug.DebugMisc;
import java.io.IOException;
import java.util.ArrayList;

public class DebugDirectoryParser
implements OffsetValidator {
    public static final byte IMAGE_DEBUG_TYPE_UNKNOWN = 0;
    public static final byte IMAGE_DEBUG_TYPE_COFF = 1;
    public static final byte IMAGE_DEBUG_TYPE_CODEVIEW = 2;
    public static final byte IMAGE_DEBUG_TYPE_FPO = 3;
    public static final byte IMAGE_DEBUG_TYPE_MISC = 4;
    public static final byte IMAGE_DEBUG_TYPE_EXCEPTION = 5;
    public static final byte IMAGE_DEBUG_TYPE_FIXUP = 6;
    public static final byte IMAGE_DEBUG_TYPE_OMAP_TO_SRC = 7;
    public static final byte IMAGE_DEBUG_TYPE_OMAP_FROM_SRC = 8;
    public static final byte IMAGE_DEBUG_TYPE_BORLAND = 9;
    public static final byte IMAGE_DEBUG_TYPE_RESERVED10 = 10;
    public static final byte IMAGE_DEBUG_TYPE_CLSID = 11;
    private ArrayList<DebugDirectory> debugFormatList = new ArrayList();
    private DebugMisc miscDebug;
    private DebugCodeView codeViewDebug;
    private DebugCOFFSymbolsHeader coffDebug;
    private DebugFixup fixupDebug;
    private BinaryReader reader;
    private long sizeOfImage;

    public DebugDirectoryParser(BinaryReader reader, long ptr, int size, long sizeOfImage) throws IOException {
        DebugDirectory debugDir;
        this.reader = reader;
        this.sizeOfImage = sizeOfImage;
        int debugFormatsCount = size / 28;
        for (int i = 0; i < debugFormatsCount && (debugDir = new DebugDirectory(reader, ptr, this)).getSizeOfData() != 0; ++i) {
            ptr += 28L;
            switch (debugDir.getType()) {
                case 11: {
                    debugDir.setDescription("CLSID");
                    break;
                }
                case 10: {
                    debugDir.setDescription("Reserved");
                    break;
                }
                case 9: {
                    debugDir.setDescription("Borland");
                    break;
                }
                case 8: {
                    debugDir.setDescription("OMAPfromSrc");
                    break;
                }
                case 7: {
                    debugDir.setDescription("OMAPtoSrc");
                    break;
                }
                case 6: {
                    debugDir.setDescription("Fixup");
                    this.fixupDebug = new DebugFixup(reader, debugDir, this);
                    break;
                }
                case 5: {
                    debugDir.setDescription("Exception");
                    break;
                }
                case 4: {
                    debugDir.setDescription("Misc");
                    this.miscDebug = new DebugMisc(reader, debugDir, this);
                    break;
                }
                case 3: {
                    debugDir.setDescription("FPO");
                    break;
                }
                case 2: {
                    debugDir.setDescription("CodeView");
                    this.codeViewDebug = new DebugCodeView(reader, debugDir, this);
                    break;
                }
                case 1: {
                    debugDir.setDescription("COFF");
                    this.coffDebug = new DebugCOFFSymbolsHeader(reader, debugDir, this);
                    break;
                }
                case 0: {
                    debugDir.setDescription("Unknown");
                    break;
                }
                default: {
                    debugDir.setDescription("DebugType-" + debugDir.getType());
                }
            }
            this.debugFormatList.add(debugDir);
        }
    }

    public DebugDirectory[] getDebugDirectories() {
        DebugDirectory[] ddArr = new DebugDirectory[this.debugFormatList.size()];
        this.debugFormatList.toArray(ddArr);
        return ddArr;
    }

    public DebugMisc getDebugMisc() {
        return this.miscDebug;
    }

    public DebugCodeView getDebugCodeView() {
        return this.codeViewDebug;
    }

    public DebugCOFFSymbolsHeader getDebugCOFFSymbolsHeader() {
        return this.coffDebug;
    }

    public DebugFixup getDebugFixup() {
        return this.fixupDebug;
    }

    @Override
    public boolean checkPointer(long ptr) {
        try {
            return ptr > 0L && ptr < this.reader.length();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean checkRVA(long rva) {
        return 0L <= rva && rva <= this.sizeOfImage;
    }
}

