/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.types.GoIMethod;
import ghidra.app.util.bin.format.golang.rtti.types.GoInterfaceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.PlateComment;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PlateComment
@StructureMapping(structureName={"runtime.itab", "internal/abi.ITab"})
public class GoItab
implements StructureMarkup<GoItab> {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoItab> context;
    @FieldMapping(fieldName={"inter", "Inter"})
    @MarkupReference(value="getInterfaceType")
    long inter;
    @FieldMapping(fieldName={"_type", "Type"})
    @MarkupReference(value="getType")
    long _type;
    @FieldMapping
    long fun;

    @Markup
    public GoInterfaceType getInterfaceType() throws IOException {
        GoInterfaceType ifaceType;
        GoType result = this.programContext.getGoTypes().getType(this.inter);
        return result instanceof GoInterfaceType ? (ifaceType = (GoInterfaceType)result) : null;
    }

    @Markup
    public GoType getType() throws IOException {
        return this.programContext.getGoTypes().getType(this._type);
    }

    public long getFuncCount() throws IOException {
        GoInterfaceType iface = this.getInterfaceType();
        GoSlice methods = iface.getMethodsSlice();
        return Math.max(1L, methods.getLen());
    }

    public GoSlice getFunSlice() throws IOException {
        long funcCount = this.getFuncCount();
        long funOffset = this.context.getStructureEnd() - (long)this.programContext.getPtrSize();
        return new GoSlice(funOffset, funcCount, funcCount, this.programContext);
    }

    private Map<Address, GoIMethod> getInterfaceMethods() throws IOException {
        GoInterfaceType iface;
        List<GoIMethod> ifaceMethods;
        long[] functionAddrs = this.getFunSlice().readUIntList(this.programContext.getPtrSize());
        if (functionAddrs.length != (ifaceMethods = (iface = this.getInterfaceType()).getMethods()).size()) {
            Msg.warn((Object)this, (Object)"Bad interface spec: %s, iface length doesn't match function impl list".formatted(this.getStructureLabel()));
            return Map.of();
        }
        HashMap<Address, GoIMethod> results = new HashMap<Address, GoIMethod>();
        for (int i = 0; i < functionAddrs.length; ++i) {
            if (functionAddrs[i] == 0L) continue;
            Address addr = this.programContext.getCodeAddress(functionAddrs[i]);
            if (!this.programContext.getProgram().getMemory().getLoadedAndInitializedAddressSet().contains(addr)) continue;
            GoIMethod imethod = ifaceMethods.get(i);
            results.put(addr, imethod);
        }
        return results;
    }

    public List<GoIMethod.GoIMethodInfo> getMethodInfoList() throws IOException {
        ArrayList<GoIMethod.GoIMethodInfo> results = new ArrayList<GoIMethod.GoIMethodInfo>();
        for (Map.Entry<Address, GoIMethod> entry : this.getInterfaceMethods().entrySet()) {
            results.add(new GoIMethod.GoIMethodInfo(this, entry.getValue(), entry.getKey()));
        }
        return results;
    }

    @Override
    public String getStructureName() throws IOException {
        return "%s__implements__%s".formatted(this.getType().getSymbolName().asString(), this.getInterfaceType().getName());
    }

    @Override
    public StructureContext<GoItab> getStructureContext() {
        return this.context;
    }

    @Override
    public String getStructureLabel() throws IOException {
        return "%s__itab".formatted(this.getStructureName());
    }

    @Override
    public String getStructureNamespace() throws IOException {
        return this.getType().getStructureNamespace();
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException {
        GoSlice funSlice = this.getFunSlice();
        List<Address> funcAddrs = Arrays.stream(funSlice.readUIntList(this.programContext.getPtrSize())).mapToObj(offset -> this.programContext.getCodeAddress(offset)).toList();
        funSlice.markupElementReferences(this.programContext.getPtrSize(), funcAddrs, session);
        GoSlice extraFunSlice = funSlice.getSubSlice(1L, funSlice.getLen() - 1L, this.programContext.getPtrSize());
        extraFunSlice.markupArray(this.getStructureName() + "_extra_itab_functions", this.getStructureNamespace(), (DataType)null, true, session);
    }

    public String toString() {
        try {
            GoInterfaceType ifaceType = this.getInterfaceType();
            Object s = "itab for %s implements %s".formatted(this.getType().getName(), ifaceType.getName());
            String methodListString = ifaceType.getMethodListString();
            if (!methodListString.isEmpty()) {
                s = (String)s + "\n// Methods\n" + methodListString;
            }
            return s;
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public void discoverGoTypes(Set<Long> discoveredTypes) {
        try {
            GoType type;
            GoInterfaceType ifaceType = this.getInterfaceType();
            if (ifaceType != null) {
                ifaceType.discoverGoTypes(discoveredTypes);
            }
            if ((type = this.getType()) != null) {
                type.discoverGoTypes(discoveredTypes);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

