/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.widgets.DropDownSelectionTextField;
import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.table.FocusableEditor;
import docking.widgets.textfield.IntegerTextField;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.function.editor.RegisterDropDownSelectionDataModel;
import ghidra.app.plugin.core.function.editor.StorageAddressModel;
import ghidra.app.plugin.core.function.editor.VarnodeInfo;
import ghidra.app.plugin.core.function.editor.VarnodeTableModel;
import ghidra.app.plugin.core.function.editor.VarnodeType;
import ghidra.app.util.AddressInput;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.apache.commons.lang3.StringUtils;

class VarnodeLocationCellEditor
extends AbstractCellEditor
implements TableCellEditor,
FocusableEditor {
    private Program program;
    private VarnodeType type;
    private Component editorComponent;
    private DropDownSelectionTextField<Register> registerEntryTextField;
    private AddressInput addressInput;
    private IntegerTextField offsetInput;
    private Comparator<Register> registerWrapperComparator = (r1, r2) -> r1.toString().compareToIgnoreCase(r2.toString());
    private VarnodeInfo currentVarnode;

    VarnodeLocationCellEditor(StorageAddressModel model) {
        this.program = model.getProgram();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() > 1;
        }
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        switch (this.type) {
            case Register: {
                String regName = this.registerEntryTextField.getText().trim();
                if (this.program.getRegister(regName) != null) break;
                if (!StringUtils.isBlank((CharSequence)regName)) {
                    Msg.showError((Object)this, (Component)this.editorComponent, (String)"Invalid Register", (Object)("Register does not exist: " + regName));
                }
                return false;
            }
            case Stack: {
                BigInteger value = this.offsetInput.getValue();
                if (value == null) break;
                try {
                    this.program.getAddressFactory().getStackSpace().getAddress(value.longValue());
                    break;
                }
                catch (AddressOutOfBoundsException e) {
                    Msg.showError((Object)this, (Component)this.editorComponent, (String)"Invalid Stack Offset", (Object)("Invalid stack offset: " + this.offsetInput.getText()));
                    return false;
                }
            }
        }
        this.fireEditingStopped();
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        switch (this.type) {
            case Register: {
                return this.registerEntryTextField.getText();
            }
            case Stack: {
                BigInteger value = this.offsetInput.getValue();
                return value == null ? null : this.program.getAddressFactory().getStackSpace().getAddress(value.longValue());
            }
            case Memory: {
                return this.addressInput.getAddress();
            }
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        VarnodeTableModel tableModel = (VarnodeTableModel)((Object)table.getModel());
        this.currentVarnode = (VarnodeInfo)tableModel.getRowObject(row);
        this.type = this.currentVarnode.getType();
        this.editorComponent = null;
        switch (this.type) {
            case Register: {
                this.editorComponent = this.createRegisterCombo(this.currentVarnode);
                break;
            }
            case Stack: {
                this.editorComponent = this.createStackOffsetEditor(this.currentVarnode);
                break;
            }
            case Memory: {
                this.editorComponent = this.createAddressEditor(this.currentVarnode);
            }
        }
        return this.editorComponent;
    }

    public void focusEditor() {
        Component component = this.editorComponent;
        if (component instanceof AddressInput) {
            AddressInput input = (AddressInput)component;
            input.focusEditor();
        } else {
            this.editorComponent.requestFocusInWindow();
        }
    }

    private Component createAddressEditor(VarnodeInfo varnode) {
        this.addressInput = new AddressInput(this.program);
        this.addressInput.setComponentBorders(BorderFactory.createEmptyBorder());
        Address address = varnode.getAddress();
        if (address != null) {
            this.addressInput.setAddress(address);
        }
        this.addressInput.addActionListener(e -> this.stopCellEditing());
        return this.addressInput;
    }

    private Component createStackOffsetEditor(VarnodeInfo varnode) {
        this.offsetInput = new IntegerTextField();
        this.offsetInput.setHexMode();
        Address address = varnode.getAddress();
        if (address != null) {
            this.offsetInput.setValue(address.getOffset());
        }
        this.offsetInput.addActionListener(e -> this.stopCellEditing());
        JComponent component = this.offsetInput.getComponent();
        component.setBorder(BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.Palette.GRAY, 1));
        return component;
    }

    private Component createRegisterCombo(VarnodeInfo varnode) {
        Register register;
        ProgramContext programContext = this.program.getProgramContext();
        ArrayList<Register> registers = new ArrayList<Register>(programContext.getRegisters());
        Iterator iter = registers.iterator();
        while (iter.hasNext()) {
            Register register2 = (Register)iter.next();
            if (!register2.isProcessorContext() && !register2.isHidden()) continue;
            iter.remove();
        }
        Collections.sort(registers, this.registerWrapperComparator);
        RegisterDropDownSelectionDataModel registerModel = new RegisterDropDownSelectionDataModel(registers);
        this.registerEntryTextField = new DropDownSelectionTextField((DropDownTextFieldDataModel)registerModel);
        this.registerEntryTextField.setBorder(null);
        this.registerEntryTextField.setShowMatchingListOnEmptyText(true);
        AtomicReference<Register> currentReg = new AtomicReference<Register>();
        Address address = varnode.getAddress();
        if (address != null && varnode.getSize() != null && (register = this.program.getRegister(address, varnode.getSize().intValue())) != null) {
            currentReg.set(register);
            this.registerEntryTextField.setText(register.getName());
        }
        this.registerEntryTextField.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                VarnodeLocationCellEditor.this.stopCellEditing();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                VarnodeLocationCellEditor.this.cancelCellEditing();
            }
        });
        this.registerEntryTextField.addActionListener(e -> this.stopCellEditing());
        Swing.runLater(() -> this.registerEntryTextField.showMatchingList());
        return this.registerEntryTextField;
    }
}

