/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.bookmark;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Schema;
import db.Table;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.bookmark.BookmarkDBAdapterV0;
import ghidra.program.database.bookmark.BookmarkDBAdapterV1;
import ghidra.program.database.bookmark.BookmarkDBAdapterV2;
import ghidra.program.database.bookmark.BookmarkDBAdapterV3;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class BookmarkDBAdapter {
    static final Schema SCHEMA = BookmarkDBAdapterV3.V3_SCHEMA;
    static final int ADDRESS_COL = 0;
    static final int CATEGORY_COL = 1;
    static final int COMMENT_COL = 2;
    static final String BOOKMARK_TABLE_NAME = "Bookmarks";

    BookmarkDBAdapter() {
    }

    static BookmarkDBAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, int[] typeIds, AddressMap addrMap, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == OpenMode.CREATE) {
            return new BookmarkDBAdapterV3(dbHandle, true, typeIds, addrMap);
        }
        try {
            BookmarkDBAdapterV3 adapter = new BookmarkDBAdapterV3(dbHandle, false, typeIds, addrMap);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            BookmarkDBAdapter adapter = BookmarkDBAdapter.findReadOnlyAdapter(dbHandle, addrMap, typeIds);
            if (openMode == OpenMode.UPGRADE) {
                adapter = BookmarkDBAdapter.upgrade(dbHandle, adapter, typeIds, addrMap, monitor);
            }
            return adapter;
        }
    }

    private static BookmarkDBAdapter findReadOnlyAdapter(DBHandle dbHandle, AddressMap addrMap, int[] typeIds) throws IOException {
        try {
            return new BookmarkDBAdapterV3(dbHandle, false, typeIds, addrMap.getOldAddressMap());
        }
        catch (VersionException versionException) {
            try {
                return new BookmarkDBAdapterV2(dbHandle, addrMap);
            }
            catch (VersionException versionException2) {
                try {
                    return new BookmarkDBAdapterV1(dbHandle, addrMap);
                }
                catch (VersionException versionException3) {
                    return new BookmarkDBAdapterV0(dbHandle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BookmarkDBAdapter upgrade(DBHandle dbHandle, BookmarkDBAdapter oldAdapter, int[] typeIds, AddressMap addrMap, TaskMonitor monitor) throws VersionException, IOException {
        if (oldAdapter instanceof BookmarkDBAdapterV0) {
            return new BookmarkDBAdapterV3(dbHandle, true, typeIds, addrMap);
        }
        if (!(oldAdapter instanceof BookmarkDBAdapterV1)) {
            dbHandle.deleteTable(BOOKMARK_TABLE_NAME);
        }
        monitor.setMessage("Upgrading Bookmarks...");
        monitor.initialize((long)(2 * oldAdapter.getBookmarkCount()));
        int cnt = 0;
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        BookmarkDBAdapterV3 tmpAdapter = null;
        try {
            tmpAdapter = new BookmarkDBAdapterV3(tmpHandle, true, typeIds, addrMap);
            for (int typeId2 : typeIds) {
                RecordIterator it = oldAdapter.getRecordsByType(typeId2);
                while (it.hasNext()) {
                    if (monitor.isCancelled()) {
                        throw new IOException("Upgrade Cancelled");
                    }
                    DBRecord rec = it.next();
                    int typeId = BookmarkDBAdapter.getTypeId(rec);
                    ((BookmarkDBAdapter)tmpAdapter).addType(typeId);
                    Address addr = oldAddrMap.decodeAddress(rec.getLongValue(0));
                    ((BookmarkDBAdapter)tmpAdapter).createBookmark(typeId, rec.getString(1), addrMap.getKey(addr, true), rec.getString(2));
                    monitor.setProgress((long)(++cnt));
                }
            }
            dbHandle.deleteTable(BOOKMARK_TABLE_NAME);
            for (int typeId : typeIds) {
                dbHandle.deleteTable(BOOKMARK_TABLE_NAME + typeId);
            }
            BookmarkDBAdapterV3 newAdapter = new BookmarkDBAdapterV3(dbHandle, true, typeIds, addrMap);
            for (int typeId : typeIds) {
                RecordIterator it = ((BookmarkDBAdapter)tmpAdapter).getRecordsByType(typeId);
                while (it.hasNext()) {
                    if (monitor.isCancelled()) {
                        throw new IOException("Upgrade Cancelled");
                    }
                    DBRecord rec = it.next();
                    ((BookmarkDBAdapter)newAdapter).updateRecord(rec);
                    monitor.setProgress((long)(++cnt));
                }
            }
            BookmarkDBAdapterV3 bookmarkDBAdapterV3 = newAdapter;
            return bookmarkDBAdapterV3;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    static int getTypeId(DBRecord rec) {
        long key = rec.getKey();
        return (int)(key >> 48);
    }

    static String mangleTypeCategory(long typeId, String category) {
        if (category == null) {
            category = "";
        }
        return typeId + "/" + category;
    }

    static String demangleTypeCategory(String typeCategory) {
        int ix = typeCategory.indexOf("/");
        if (ix < 0) {
            return typeCategory;
        }
        return typeCategory.substring(ix + 1);
    }

    DBRecord createBookmark(int typeId, String category, long index, String comment) throws IOException {
        throw new UnsupportedOperationException("Bookmarks are read-only and may not be created");
    }

    void updateRecord(DBRecord rec) throws IOException {
        throw new UnsupportedOperationException("Bookmarks are read-only and may not be modified");
    }

    void deleteRecord(long id) throws IOException {
        throw new UnsupportedOperationException("Bookmarks are read-only and may not be deleted");
    }

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract RecordIterator getRecordsByTypeAtAddress(int var1, long var2) throws IOException;

    abstract RecordIterator getRecordsByTypeStartingAtAddress(int var1, long var2, boolean var4) throws IOException;

    abstract RecordIterator getRecordsByTypeForAddressRange(int var1, long var2, long var4) throws IOException;

    abstract RecordIterator getRecordsByTypeAndCategory(int var1, String var2) throws IOException;

    abstract RecordIterator getRecordsByType(int var1) throws IOException;

    abstract String[] getCategories(int var1) throws IOException;

    abstract AddressSetView getBookmarkAddresses(int var1) throws IOException;

    abstract int getBookmarkCount(int var1);

    abstract int getBookmarkCount();

    void addType(int typeID) throws IOException {
        throw new UnsupportedOperationException();
    }

    void deleteType(int typeID) throws IOException {
        throw new UnsupportedOperationException();
    }

    boolean hasTable(int typeID) {
        throw new UnsupportedOperationException();
    }

    Table getTable(int typeID) {
        throw new UnsupportedOperationException();
    }

    void reloadTables() {
        throw new UnsupportedOperationException();
    }
}

