/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import com.contrastsecurity.sarif.SarifSchema210;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.plugin.core.decompiler.taint.TaintLabel;
import ghidra.app.plugin.core.decompiler.taint.TaintOptions;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintQueryResult;
import ghidra.app.script.GhidraScript;
import ghidra.app.services.ConsoleService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.DynamicHash;
import ghidra.program.model.pcode.HighConstant;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighGlobal;
import ghidra.program.model.pcode.HighLocal;
import ghidra.program.model.pcode.HighOther;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeSyntaxTree;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface TaintState
extends ExtensionPoint {
    public static TaintState newInstance(TaintPlugin plugin, String type) {
        List list = ClassSearcher.getClasses(TaintState.class).stream().toList();
        Class[] constructorArgumentTypes = new Class[]{TaintPlugin.class};
        Object[] args = new Object[]{plugin};
        for (Class clazz : list) {
            if (!clazz.getName().toLowerCase().contains(type)) continue;
            try {
                Constructor constructor = clazz.getConstructor(constructorArgumentTypes);
                Object obj = constructor.newInstance(plugin);
                return (TaintState)TaintState.class.cast(obj);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate TaintState");
            }
        }
        Msg.error((Object)plugin, (Object)("No match for engine = " + type));
        return null;
    }

    public String getName();

    public boolean queryIndex(Program var1, PluginTool var2, QueryType var3);

    public String getQueryName();

    public TaintLabel toggleMark(MarkType var1, ClangToken var2) throws PcodeException;

    public Set<TaintLabel> getTaintLabels(MarkType var1);

    public boolean isValid();

    public AddressSet getTaintAddressSet();

    public void setTaintAddressSet(AddressSet var1);

    public void augmentAddressSet(ClangToken var1);

    public void clearTaint();

    public boolean isSink(HighVariable var1);

    public void clearMarkers();

    public void loadTaintData(Program var1, File var2);

    public SarifSchema210 getData();

    public void clearData();

    public TaintOptions getOptions();

    public boolean hasMarks();

    public void setMonitor(TaskMonitor var1);

    public boolean isCancelled();

    public void cancel();

    public void setTaintVarnodeMap(Map<Address, Set<TaintQueryResult>> var1, TaskType var2);

    public Map<Address, Set<TaintQueryResult>> getTaintVarnodeMap();

    public Set<TaintQueryResult> getQuerySet(Address var1);

    public void buildIndex(List<String> var1, String var2, String var3, String var4);

    public GhidraScript getExportScript(ConsoleService var1, boolean var2);

    public void setTaskType(TaskType var1);

    public TaintLabel getLabelForToken(MarkType var1, ClangToken var2);

    public static String varName(ClangToken token, boolean append) {
        String tokenText = token.getText();
        if (token instanceof ClangFieldToken) {
            ClangFieldToken ftoken = (ClangFieldToken)token;
            ClangVariableToken vtoken = TaintState.getParentToken(ftoken);
            if (vtoken == null) {
                return tokenText;
            }
            HighVariable hv = vtoken.getHighVariable();
            Varnode rep = hv.getRepresentative();
            return rep.getAddress().toString();
        }
        HighVariable hv = token.getHighVariable();
        if (hv != null) {
            if (hv instanceof HighLocal && token.getVarnode() == null) {
                int offset = hv.getOffset();
                Varnode rep = hv.getRepresentative();
                return rep.getAddress().subtract((long)offset).toString();
            }
            return TaintState.hvarName(hv);
        }
        return tokenText;
    }

    private static String hvarName(HighVariable hv) {
        Varnode rep = hv.getRepresentative();
        if (rep.getAddress().isUniqueAddress()) {
            HighFunction hf = hv.getHighFunction();
            DynamicHash dynamicHash = new DynamicHash(rep, (PcodeSyntaxTree)hf);
            return "hv" + Long.toString(dynamicHash.getHash());
        }
        if (hv.getName() == null || hv.getName().equals("UNNAMED")) {
            if (hv instanceof HighConstant || hv instanceof HighOther) {
                Address addr = rep.getAddress();
                return addr.toString();
            }
            if (hv instanceof HighLocal) {
                Address addr = rep.getAddress();
                return addr.toString();
            }
            if (hv instanceof HighGlobal) {
                Address addr;
                Function fn = hv.getHighFunction().getFunction();
                SymbolTable symbolTable = fn.getProgram().getSymbolTable();
                Symbol symbol = symbolTable.getPrimarySymbol(addr = rep.getAddress());
                if (symbol != null) {
                    return symbol.getName();
                }
                return addr.toString();
            }
            return null;
        }
        return hv.getName();
    }

    public static ClangVariableToken getParentToken(ClangFieldToken token) {
        ClangTokenGroup group = (ClangTokenGroup)token.Parent();
        Iterator iterator = group.tokenIterator(true);
        ClangVariableToken parent = null;
        while (iterator.hasNext()) {
            ClangFieldToken ftoken;
            ClangToken next = (ClangToken)iterator.next();
            if (next instanceof ClangVariableToken) {
                ClangVariableToken vtoken;
                parent = vtoken = (ClangVariableToken)next;
            }
            if (!(next instanceof ClangFieldToken) || !(ftoken = (ClangFieldToken)next).equals(token)) continue;
            return parent;
        }
        return null;
    }

    public static boolean isActualParam(ClangToken token) {
        String mnemonic;
        PcodeOp pcodeOp = token.getPcodeOp();
        if (pcodeOp != null && (mnemonic = pcodeOp.getMnemonic()).contains("CALL")) {
            for (Varnode input : pcodeOp.getInputs()) {
                if (!input.equals((Object)token.getVarnode())) continue;
                return true;
            }
        }
        return false;
    }

    public static enum TaskType {
        SET_TAINT,
        SET_DELTA,
        APPLY_DELTA;

    }

    public static enum QueryType {
        SRCSINK,
        DEFAULT,
        CUSTOM;

    }

    public static enum MarkType {
        SOURCE,
        SINK,
        GATE;

    }
}

