/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class NameSampleTypeFilter
extends FilterObjectStream<NameSample, NameSample> {
    private final Set<String> types;

    public NameSampleTypeFilter(String[] types, ObjectStream<NameSample> samples) {
        super(samples);
        this.types = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(types)));
    }

    public NameSampleTypeFilter(Set<String> types, ObjectStream<NameSample> samples) {
        super(samples);
        this.types = Set.copyOf(types);
    }

    @Override
    public NameSample read() throws IOException {
        NameSample sample = (NameSample)this.samples.read();
        if (sample != null) {
            ArrayList<Span> filteredNames = new ArrayList<Span>();
            for (Span name : sample.getNames()) {
                if (!this.types.contains(name.getType())) continue;
                filteredNames.add(name);
            }
            return new NameSample(sample.getId(), sample.getSentence(), filteredNames.toArray(new Span[0]), null, sample.isClearAdaptiveDataSet());
        }
        return null;
    }
}

