/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.maps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.plugin.ai.maps.MapModelProvider;

public class ControllerMapModelProvider
implements MapModelProvider {
    @Override
    public MapModel getCurrentMapModel() {
        Controller controller = Controller.getCurrentController();
        if (controller == null) {
            return null;
        }
        return controller.getMap();
    }

    @Override
    public List<MapModel> getOpenMapModels() {
        Controller controller = Controller.getCurrentController();
        if (controller == null) {
            return Collections.emptyList();
        }
        IMapViewManager mapViewManager = controller.getMapViewManager();
        if (mapViewManager == null) {
            return Collections.emptyList();
        }
        Collection mapModels = mapViewManager.getMaps().values();
        if (mapModels == null || mapModels.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet uniqueMapModels = new LinkedHashSet(mapModels);
        return new ArrayList<MapModel>(uniqueMapModels);
    }

    @Override
    public NodeModel getCurrentSelectedNodeModel() {
        Controller controller = Controller.getCurrentController();
        if (controller == null) {
            return null;
        }
        IMapSelection selection = controller.getSelection();
        if (selection == null) {
            return null;
        }
        return selection.getSelected();
    }
}

