/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.memory.ChatMemory;
import java.util.ArrayList;
import java.util.List;
import org.freeplane.plugin.ai.chat.AssistantProfileChatMemory;
import org.freeplane.plugin.ai.chat.AssistantProfileSwitchMessage;
import org.freeplane.plugin.ai.chat.InstructionAckMessage;
import org.freeplane.plugin.ai.chat.RemovedForSpaceSystemMessage;
import org.freeplane.plugin.ai.chat.TranscriptHiddenSystemMessage;
import org.freeplane.plugin.ai.chat.history.AssistantProfileTranscriptEntry;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptEntry;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptRole;
import org.freeplane.plugin.ai.tools.MessageBuilder;

class TranscriptMemoryMapper {
    TranscriptMemoryMapper() {
    }

    void seedTranscriptWithHiddenExchange(ChatMemory memory, Iterable<ChatTranscriptEntry> entries, String hiddenSystemMessage) {
        AssistantProfileChatMemory assistantProfileMemory;
        if (memory == null) {
            return;
        }
        memory.clear();
        AssistantProfileChatMemory assistantProfileChatMemory = assistantProfileMemory = memory instanceof AssistantProfileChatMemory ? (AssistantProfileChatMemory)memory : null;
        if (entries != null) {
            for (ChatTranscriptEntry entry : entries) {
                if (assistantProfileMemory != null && entry != null && entry.getRole() == ChatTranscriptRole.REMOVED_FOR_SPACE_SYSTEM) {
                    assistantProfileMemory.markContextWindowStart();
                    continue;
                }
                ChatMessage message = this.toChatMessage(entry);
                if (message == null) continue;
                memory.add(message);
            }
        }
        if (hiddenSystemMessage != null && !hiddenSystemMessage.trim().isEmpty()) {
            memory.add((ChatMessage)new TranscriptHiddenSystemMessage(hiddenSystemMessage));
        }
    }

    List<ChatTranscriptEntry> toTranscriptEntries(ChatMemory memory) {
        if (memory == null) {
            return new ArrayList<ChatTranscriptEntry>();
        }
        if (memory instanceof AssistantProfileChatMemory) {
            return ((AssistantProfileChatMemory)memory).transcriptEntriesForPersistence();
        }
        ArrayList<ChatTranscriptEntry> entries = new ArrayList<ChatTranscriptEntry>();
        for (ChatMessage message : memory.messages()) {
            ChatTranscriptEntry entry = this.toTranscriptEntry(message);
            if (entry == null) continue;
            entries.add(entry);
        }
        return entries;
    }

    private ChatMessage toChatMessage(ChatTranscriptEntry entry) {
        if (entry == null || entry.getRole() == null) {
            return null;
        }
        if (entry.getRole() == ChatTranscriptRole.ASSISTANT) {
            if (entry.getText() == null) {
                return null;
            }
            return new AiMessage(entry.getText());
        }
        if (entry.getRole() == ChatTranscriptRole.ASSISTANT_PROFILE_SYSTEM) {
            if (!(entry instanceof AssistantProfileTranscriptEntry)) {
                return null;
            }
            AssistantProfileTranscriptEntry assistantProfileEntry = (AssistantProfileTranscriptEntry)entry;
            return new AssistantProfileSwitchMessage(assistantProfileEntry.getProfileId(), assistantProfileEntry.getProfileName());
        }
        if (entry.getRole() == ChatTranscriptRole.REMOVED_FOR_SPACE_SYSTEM) {
            if (entry.getText() == null) {
                return null;
            }
            return MessageBuilder.buildSystemInstructionUserMessage(entry.getText());
        }
        if (entry.getText() == null) {
            return null;
        }
        return new UserMessage(entry.getText());
    }

    private ChatTranscriptEntry toTranscriptEntry(ChatMessage message) {
        if (message == null) {
            return null;
        }
        if (message instanceof AssistantProfileSwitchMessage) {
            AssistantProfileSwitchMessage profileMessage = (AssistantProfileSwitchMessage)message;
            return new AssistantProfileTranscriptEntry(profileMessage.getProfileId(), profileMessage.getProfileName(), false);
        }
        if (message instanceof RemovedForSpaceSystemMessage) {
            return new ChatTranscriptEntry(ChatTranscriptRole.REMOVED_FOR_SPACE_SYSTEM, ((RemovedForSpaceSystemMessage)message).text());
        }
        if (message instanceof UserMessage) {
            String text = ((UserMessage)message).singleText();
            if (text == null || text.trim().isEmpty() || text.startsWith("control instruction, please confirm with \"ok\": ")) {
                return null;
            }
            return new ChatTranscriptEntry(ChatTranscriptRole.USER, text);
        }
        if (message instanceof AiMessage && !(message instanceof InstructionAckMessage)) {
            String text = ((AiMessage)message).text();
            if (text == null || text.trim().isEmpty()) {
                return null;
            }
            return new ChatTranscriptEntry(ChatTranscriptRole.ASSISTANT, text);
        }
        return null;
    }
}

