/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.indent;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLParserContext;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLHeuristicScanner;

public class SQLIndenter {
    private IDocument document;
    private int indent;
    private int position;
    private int token;
    private int line;
    private SQLHeuristicScanner scanner;
    private SQLParserContext context;

    public SQLIndenter(IDocument document, SQLSyntaxManager syntaxManager, SQLHeuristicScanner scanner) {
        this.document = document;
        this.scanner = scanner;
        this.context = new SQLParserContext((DBPDataSource)null, syntaxManager, new SQLRuleManager(syntaxManager), document);
    }

    public String getReferenceIndentation(int offset) {
        int unit = this.findReferencePosition(offset);
        if (unit == -1) {
            return null;
        }
        return this.getLeadingWhitespace(unit);
    }

    public String computeIndentation(int offset) {
        return this.computeIndentation(offset, false);
    }

    public String computeIndentation(int offset, boolean assumeOpening) {
        this.indent = 1;
        StringBuilder indent = this.createIndent(this.indent);
        if (this.indent < 0) {
            this.unindent(indent);
        }
        if (indent == null) {
            return null;
        }
        indent.append(this.getReferenceIndentation(offset));
        return indent.toString();
    }

    private String getLeadingWhitespace(int offset) {
        try {
            IRegion line = this.document.getLineInformationOfOffset(offset);
            int lineOffset = line.getOffset();
            int nonWS = this.scanner.findNonWhitespaceForwardInAnyPartition(lineOffset, lineOffset + line.getLength());
            if (nonWS < 0) {
                return "";
            }
            int indentLength = nonWS - lineOffset;
            StringBuilder indent = SQLIndenter.createIndent();
            if (indentLength >= indent.length() && this.scanner.endsWithDelimiter(lineOffset, lineOffset + line.getLength() - 1)) {
                SQLScriptElement currentQuery = SQLScriptParser.extractQueryAtPos((SQLParserContext)this.context, (int)offset, (boolean)false);
                nonWS = currentQuery.getOffset();
                lineOffset = this.document.getLineInformationOfOffset(currentQuery.getOffset()).getOffset();
            }
            return this.document.get(lineOffset, nonWS - lineOffset);
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public void unindent(StringBuilder indent) {
        this.unindent(indent, 1);
    }

    public void unindent(StringBuilder indent, int number) {
        StringBuilder oneIndent = SQLIndenter.createIndent();
        for (int k = 0; k < number; ++k) {
            int i = indent.lastIndexOf(oneIndent.toString());
            if (i == -1) continue;
            indent.delete(i, i + oneIndent.length());
        }
    }

    public String unindent(String indent, int number) {
        StringBuilder newIndent = new StringBuilder(indent);
        this.unindent(newIndent, number);
        return newIndent.toString();
    }

    public StringBuilder createIndent(int indent) {
        StringBuilder oneIndent = SQLIndenter.createIndent();
        StringBuilder ret = new StringBuilder();
        while (indent-- > 0) {
            ret.append((CharSequence)oneIndent);
        }
        return ret;
    }

    public static StringBuilder createIndent() {
        IPreferenceStore preferenceStore = EditorsPlugin.getDefault().getPreferenceStore();
        boolean useSpaces = preferenceStore.getBoolean("spacesForTabs");
        StringBuilder oneIndent = new StringBuilder();
        if (!useSpaces) {
            oneIndent.append('\t');
        } else {
            int tabWidth = preferenceStore.getInt("tabWidth");
            for (int i = 0; i < tabWidth; ++i) {
                oneIndent.append(' ');
            }
        }
        return oneIndent;
    }

    public int findReferencePosition(int offset) {
        this.indent = 0;
        this.position = offset;
        this.nextToken();
        return this.skipToPreviousListItemOrListStart();
    }

    private int skipToPreviousListItemOrListStart() {
        int startLine = this.line;
        int startPosition = this.position;
        while (true) {
            this.nextToken();
            if (this.line < startLine) {
                try {
                    int lineOffset = this.document.getLineOffset(startLine);
                    int bound = Math.min(this.document.getLength(), startPosition + 1);
                    int n = this.scanner.findNonWhitespaceForwardInAnyPartition(lineOffset, bound);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return startPosition;
            }
            switch (this.token) {
                case -1: {
                    return 0;
                }
            }
        }
    }

    private void nextToken() {
        this.nextToken(this.position);
    }

    public void nextToken(int start) {
        this.token = this.scanner.previousToken(start - 1, -2);
        this.position = this.scanner.getPosition() + 1;
        try {
            this.line = this.document.getLineOfOffset(this.position);
        }
        catch (BadLocationException e) {
            this.line = -1;
        }
    }
}

