/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model.plan;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.AltibaseConstants;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataTypeDomain;
import org.jkiss.dbeaver.ext.altibase.model.plan.AltibasePlanBuilder;
import org.jkiss.dbeaver.ext.altibase.model.plan.AltibasePlanNode;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;

public class AltibaseExecutionPlan
extends AbstractExecutionPlan {
    static final Log log = Log.getLog(AltibaseExecutionPlan.class);
    private AltibaseDataSource dataSource;
    private JDBCSession session;
    private String query;
    private List<AltibasePlanNode> rootNodes;
    private String planQuery;
    private static final String setExplainPlan = "setExplainPlan";

    public AltibaseExecutionPlan(AltibaseDataSource dataSource, JDBCSession session, String query) {
        this.dataSource = dataSource;
        this.session = session;
        this.query = query;
        this.planQuery = "";
    }

    public AltibaseExecutionPlan(String query, List<AltibasePlanNode> nodes) {
        this.query = query;
        this.rootNodes = nodes;
    }

    public void explain() throws DBException {
        try (JDBCPreparedStatement dbStat = this.session.prepareStatement(this.getQueryString());){
            String plan = this.getExplainPlan(this.session, this.query);
            this.rootNodes = AltibasePlanBuilder.build(this.dataSource, plan);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)this.session.getExecutionContext());
        }
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() throws DBException {
        return this.planQuery;
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.rootNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExplainPlan(JDBCSession session, String query) {
        Statement stmt = null;
        Connection conn = null;
        Class<?> clazz = null;
        Method method = null;
        AltibaseConstants.ExplainPlan expPlan = null;
        try {
            conn = session.getOriginal();
            clazz = conn.getClass();
            method = clazz.getMethod(setExplainPlan, Byte.TYPE);
            if (method == null) {
                throw new NoSuchMethodException(String.format("Unable to find the target method: [class] %s, [method] %s, [argument type] %s", clazz.getName(), setExplainPlan, AltibaseDataTypeDomain.BYTE.getTypeName().toLowerCase()));
            }
            expPlan = AltibaseConstants.ExplainPlan.getByIndex(this.dataSource.getContainer().getPreferenceStore().getInt("altibase.explain.plan.type"));
            method.invoke((Object)conn, expPlan.getArgValue());
            stmt = conn.prepareStatement(query);
            if (expPlan == AltibaseConstants.ExplainPlan.ON) {
                if (query.trim().toUpperCase().startsWith("SELECT")) {
                    stmt.getClass().getMethod("executeQuery", new Class[0]).invoke((Object)stmt, new Object[0]);
                } else {
                    stmt.getClass().getMethod("execute", new Class[0]).invoke((Object)stmt, new Object[0]);
                }
            }
            this.planQuery = (String)stmt.getClass().getMethod("getExplainPlan", new Class[0]).invoke((Object)stmt, new Object[0]);
        }
        catch (Exception e) {
            log.error((Object)("Failed to execute explain plan: " + e.getMessage()));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.planQuery;
    }
}

