﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDutyRequest.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/S3ObjectForSendObjectMalwareScan.h>

#include <utility>

namespace Aws {
namespace GuardDuty {
namespace Model {

/**
 */
class SendObjectMalwareScanRequest : public GuardDutyRequest {
 public:
  AWS_GUARDDUTY_API SendObjectMalwareScanRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "SendObjectMalwareScan"; }

  AWS_GUARDDUTY_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The S3 object information for the object you want to scan. The bucket must
   * have a Malware Protection plan configured to use this API.</p>
   */
  inline const S3ObjectForSendObjectMalwareScan& GetS3Object() const { return m_s3Object; }
  inline bool S3ObjectHasBeenSet() const { return m_s3ObjectHasBeenSet; }
  template <typename S3ObjectT = S3ObjectForSendObjectMalwareScan>
  void SetS3Object(S3ObjectT&& value) {
    m_s3ObjectHasBeenSet = true;
    m_s3Object = std::forward<S3ObjectT>(value);
  }
  template <typename S3ObjectT = S3ObjectForSendObjectMalwareScan>
  SendObjectMalwareScanRequest& WithS3Object(S3ObjectT&& value) {
    SetS3Object(std::forward<S3ObjectT>(value));
    return *this;
  }
  ///@}
 private:
  S3ObjectForSendObjectMalwareScan m_s3Object;
  bool m_s3ObjectHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
