﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/mediaconvert/MediaConvert_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace MediaConvert
{
namespace Model
{
  enum class JobsQueryFilterKey
  {
    NOT_SET,
    queue,
    status,
    fileInput,
    jobEngineVersionRequested,
    jobEngineVersionUsed,
    audioCodec,
    videoCodec
  };

namespace JobsQueryFilterKeyMapper
{
AWS_MEDIACONVERT_API JobsQueryFilterKey GetJobsQueryFilterKeyForName(const Aws::String& name);

AWS_MEDIACONVERT_API Aws::String GetNameForJobsQueryFilterKey(JobsQueryFilterKey value);
} // namespace JobsQueryFilterKeyMapper
} // namespace Model
} // namespace MediaConvert
} // namespace Aws
