/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves.rewrite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.tomcat.util.res.StringManager;

public class QuotedStringTokenizer {
    protected static final StringManager sm = StringManager.getManager(QuotedStringTokenizer.class);
    private final Iterator<String> tokenIterator;
    private final int tokenCount;
    private int returnedTokens = 0;

    public QuotedStringTokenizer(String string) {
        List<Object> list = string != null ? this.tokenizeText(string) : Collections.emptyList();
        this.tokenCount = list.size();
        this.tokenIterator = list.iterator();
    }

    private List<String> tokenizeText(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        WordMode wordMode = WordMode.SPACES;
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (wordMode) {
                case SPACES: {
                    wordMode = this.handleSpaces(stringBuilder, c);
                    continue block7;
                }
                case QUOTED: {
                    wordMode = this.handleQuoted(arrayList, stringBuilder, c);
                    continue block7;
                }
                case ESCAPED: {
                    stringBuilder.append(c);
                    wordMode = WordMode.QUOTED;
                    continue block7;
                }
                case SIMPLE: {
                    wordMode = this.handleSimple(arrayList, stringBuilder, c);
                    continue block7;
                }
                case COMMENT: {
                    if (c != '\r' && c != '\n') continue block7;
                    wordMode = WordMode.SPACES;
                    continue block7;
                }
                default: {
                    throw new IllegalStateException(sm.getString("quotedStringTokenizer.tokenizeError", new Object[]{string, i, wordMode}));
                }
            }
        }
        String string2 = stringBuilder.toString();
        if (!string2.isEmpty()) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    private WordMode handleSimple(List<String> list, StringBuilder stringBuilder, char c) {
        if (Character.isWhitespace(c)) {
            list.add(stringBuilder.toString());
            stringBuilder.setLength(0);
            return WordMode.SPACES;
        }
        stringBuilder.append(c);
        return WordMode.SIMPLE;
    }

    private WordMode handleQuoted(List<String> list, StringBuilder stringBuilder, char c) {
        if (c == '\"') {
            list.add(stringBuilder.toString());
            stringBuilder.setLength(0);
            return WordMode.SPACES;
        }
        if (c == '\\') {
            return WordMode.ESCAPED;
        }
        stringBuilder.append(c);
        return WordMode.QUOTED;
    }

    private WordMode handleSpaces(StringBuilder stringBuilder, char c) {
        if (!Character.isWhitespace(c)) {
            if (c == '\"') {
                return WordMode.QUOTED;
            }
            if (c == '#') {
                return WordMode.COMMENT;
            }
            stringBuilder.append(c);
            return WordMode.SIMPLE;
        }
        return WordMode.SPACES;
    }

    public boolean hasMoreTokens() {
        return this.tokenIterator.hasNext();
    }

    public String nextToken() {
        ++this.returnedTokens;
        return this.tokenIterator.next();
    }

    public int countTokens() {
        return this.tokenCount - this.returnedTokens;
    }

    static enum WordMode {
        SPACES,
        QUOTED,
        ESCAPED,
        SIMPLE,
        COMMENT;

    }
}

