/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import jakarta.servlet.Filter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.tomcat.util.descriptor.web.Constants;
import org.apache.tomcat.util.res.StringManager;

public class FilterDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private String description = null;
    private String displayName = null;
    private transient Filter filter = null;
    private String filterClass = null;
    private String filterName = null;
    private String largeIcon = null;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private String smallIcon = null;
    private String asyncSupported = null;
    private boolean asyncSupportedBoolean = true;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String string) {
        this.filterClass = string;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException(sm.getString("filterDef.invalidFilterName", new Object[]{string}));
        }
        this.filterName = string;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String string) {
        this.largeIcon = string;
    }

    public Map<String, String> getParameterMap() {
        return this.parameters;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String string) {
        this.smallIcon = string;
    }

    public String getAsyncSupported() {
        return this.asyncSupported;
    }

    public void setAsyncSupported(String string) {
        this.asyncSupported = string;
        this.asyncSupportedBoolean = !"false".equalsIgnoreCase(string);
    }

    public boolean getAsyncSupportedBoolean() {
        return this.asyncSupportedBoolean;
    }

    public void addInitParameter(String string, String string2) {
        if (this.parameters.containsKey(string)) {
            return;
        }
        this.parameters.put(string, string2);
    }

    public String toString() {
        return "FilterDef[filterName=" + this.filterName + ", filterClass=" + this.filterClass + "]";
    }
}

