/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static void growToSize(List<?> list, int size) {
        if (list.size() >= size) {
            return;
        }
        if (list instanceof ArrayList) {
            ArrayList a = (ArrayList)list;
            a.ensureCapacity(size);
        } else if (list instanceof Vector) {
            Vector v = (Vector)list;
            v.setSize(size);
            return;
        }
        while (list.size() < size) {
            list.add(null);
        }
    }

    public static <T> @Nullable T getLast(List<T> list) {
        int size = list.size();
        return size > 0 ? (T)list.get(size - 1) : null;
    }
}

