/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.Compact64bitInt;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;

public class ObjectGroupObjectDeclare
extends StreamObject {
    public ExGuid objectExtendedGUID = new ExGuid();
    public Compact64bitInt objectPartitionID = new Compact64bitInt();
    public Compact64bitInt objectDataSize = new Compact64bitInt();
    public Compact64bitInt objectReferencesCount = new Compact64bitInt();
    public Compact64bitInt cellReferencesCount = new Compact64bitInt();

    public ObjectGroupObjectDeclare() {
        super(StreamObjectTypeHeaderStart.ObjectGroupObjectDeclare);
        this.objectPartitionID.setDecodedValue(1L);
        this.objectReferencesCount.setDecodedValue(1L);
        this.cellReferencesCount.setDecodedValue(0L);
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(currentIndex.get());
        this.objectExtendedGUID = BasicObject.parse(byteArray, index, ExGuid.class);
        this.objectPartitionID = BasicObject.parse(byteArray, index, Compact64bitInt.class);
        this.objectDataSize = BasicObject.parse(byteArray, index, Compact64bitInt.class);
        this.objectReferencesCount = BasicObject.parse(byteArray, index, Compact64bitInt.class);
        this.cellReferencesCount = BasicObject.parse(byteArray, index, Compact64bitInt.class);
        if (index.get() - currentIndex.get() != lengthOfItems) {
            throw new StreamObjectParseErrorException(currentIndex.get(), "ObjectGroupObjectDeclare", "Stream object over-parse error", null);
        }
        currentIndex.set(index.get());
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) throws IOException {
        int itemsIndex = byteList.size();
        byteList.addAll(this.objectExtendedGUID.serializeToByteList());
        byteList.addAll(this.objectPartitionID.serializeToByteList());
        byteList.addAll(this.objectDataSize.serializeToByteList());
        byteList.addAll(this.objectReferencesCount.serializeToByteList());
        byteList.addAll(this.cellReferencesCount.serializeToByteList());
        return byteList.size() - itemsIndex;
    }
}

