/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.common.Rounding;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregator;
import org.opensearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregatorSupplier;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.internal.SearchContext;

public final class AutoDateHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int numBuckets;
    private AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(AutoDateHistogramAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN), AutoDateHistogramAggregator::build, true);
    }

    public AutoDateHistogramAggregatorFactory(String name, ValuesSourceConfig config, int numBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.numBuckets = numBuckets;
        this.roundingInfos = roundingInfos;
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        AutoDateHistogramAggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(AutoDateHistogramAggregationBuilder.REGISTRY_KEY, this.config);
        Function<Rounding, Rounding.Prepared> roundingPreparer = this.config.getValuesSource().roundingPreparer(searchContext.getQueryShardContext().getIndexReader());
        return aggregatorSupplier.build(this.name, this.factories, this.numBuckets, this.roundingInfos, roundingPreparer, this.config, searchContext, parent, cardinality, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return AutoDateHistogramAggregator.build(this.name, this.factories, this.numBuckets, this.roundingInfos, Rounding::prepareForUnknown, this.config, searchContext, parent, CardinalityUpperBound.NONE, metadata);
    }

    @Override
    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

