/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action;

import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportService;

public class TransportActionNodeProxy<Request extends ActionRequest, Response extends ActionResponse> {
    private final TransportService transportService;
    private final ActionType<Response> action;
    private final TransportRequestOptions transportOptions;

    public TransportActionNodeProxy(Settings settings, ActionType<Response> action, TransportService transportService) {
        this.action = action;
        this.transportService = transportService;
        this.transportOptions = action.transportOptions(settings);
    }

    public void execute(DiscoveryNode node, Request request, ActionListener<Response> listener) {
        ActionRequestValidationException validationException = ((ActionRequest)request).validate();
        if (validationException != null) {
            listener.onFailure((Exception)((Object)validationException));
            return;
        }
        this.transportService.sendRequest(node, this.action.name(), (TransportRequest)request, this.transportOptions, new ActionListenerResponseHandler<Response>(listener, this.action.getResponseReader()));
    }
}

