/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.stream.Stream;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.SingletonChildMap;
import org.gradle.internal.snapshot.VfsRelativePath;

public class EmptyChildMap<T>
implements ChildMap<T> {
    private static final EmptyChildMap<Object> INSTANCE = new EmptyChildMap();

    public static <T> EmptyChildMap<T> getInstance() {
        return INSTANCE;
    }

    private EmptyChildMap() {
    }

    @Override
    public <R> R withNode(VfsRelativePath targetPath, CaseSensitivity caseSensitivity, ChildMap.NodeHandler<T, R> handler) {
        return handler.handleUnrelatedToAnyChild();
    }

    @Override
    public <RESULT> ChildMap<RESULT> invalidate(VfsRelativePath targetPath, CaseSensitivity caseSensitivity, ChildMap.InvalidationHandler<T, RESULT> handler) {
        handler.handleUnrelatedToAnyChild();
        return EmptyChildMap.getInstance();
    }

    @Override
    public ChildMap<T> store(VfsRelativePath targetPath, CaseSensitivity caseSensitivity, ChildMap.StoreHandler<T> storeHandler) {
        return new SingletonChildMap<T>(targetPath.getAsString(), storeHandler.createChild());
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Stream<ChildMap.Entry<T>> stream() {
        return Stream.empty();
    }

    public String toString() {
        return "";
    }
}

