# Neo Geo/Yamaha YM2610

originally an arcade board, but SNK shortly adapted it to a rather expensive video game console with the world's biggest cartridges because some people liked the system so much they wanted a home version of it.

its soundchip is a 4-in-1: 4ch 4-op FM, YM2149 (AY-3-8910 clone) and [2 different format ADPCM](https://wiki.neogeodev.org/index.php?title=ADPCM) in a single package!

## effects

- `10xy`: **set LFO parameters.**
  - `x` toggles the LFO.
  - `y` sets its speed.
- `11xx`: **set feedback of channel.**
- `12xx`: **set operator 1 level.**
- `13xx`: **set operator 2 level.**
- `14xx`: **set operator 3 level.**
- `15xx`: **set operator 4 level.**
- `16xy`: **set multiplier of operator.**
  - `x` is the operator (1-4).
  - `y` is the new MULT value..
- `18xx`: **toggle extended channel 2 mode.**
  - 0 disables it and 1 enables it.
  - only in extended channel 2 chip.
- `19xx`: **set attack of all operators.**
- `1Axx`: **set attack of operator 1.**
- `1Bxx`: **set attack of operator 2.**
- `1Cxx`: **set attack of operator 3.**
- `1Dxx`: **set attack of operator 4.**
- `20xx`: **set SSG channel mode.**
  - `0`: square
  - `1`: noise
  - `2`: square and noise
  - `3`: nothing (apparently)
  - `4`: envelope and square
  - `5`: envelope and noise
  - `6`: envelope and square and noise
  - `7`: nothing
- `21xx`: **set noise frequency.** range is `00` to `1F`.
- `22xy`: **set envelope mode.**
  - `x` sets the envelope shape:
    - `0`: `\___` decay
    - `4`: `/___` attack once
    - `8`: `\\\\` saw
    - `9`: `\___` decay
    - `A`: `\/\/` inverse obelisco
    - `B`: `\¯¯¯` decay once
    - `C`: `////` inverse saw
    - `D`: `/¯¯¯` attack
    - `E`: `/\/\` obelisco
    - `F`: `/___` attack once
  - if `y` is 1 then the envelope will affect this channel.
- `23xx`: **set envelope period low byte.**
- `24xx`: **set envelope period high byte.**
- `25xx`: **slide envelope period up.**
- `26xx`: **slide envelope period down.**
- `29xy`: **enable SSG auto-envelope mode.**
  - in this mode the envelope period is set to the channel's notes, multiplied by a fraction.
  - `x` is the numerator.
  - `y` is the denominator.
  - if `x` or `y` are 0 this will disable auto-envelope mode.
- `30xx`: **enable envelope hard reset.**
  - this works by inserting a quick release and tiny delay before a new note.
- `50xy`: **set AM of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` determines whether AM is on.
- `51xy`: **set SL of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `52xy`: **set RR of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `53xy`: **set DT of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value:
    - 0: +0
    - 1: +1
    - 2: +2
    - 3: +3
    - 4: -0
    - 5: -3
    - 6: -2
    - 7: -1
- `54xy`: **set RS of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `55xy`: **set SSG-EG of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value (0-8).
    - values between 0 and 7 set SSG-EG.
    - value 8 disables it.
- `56xx`: **set DR of all operators.**
- `57xx`: **set DR of operator 1.**
- `58xx`: **set DR of operator 2.**
- `59xx`: **set DR of operator 3.**
- `5Axx`: **set DR of operator 4.**
- `5Bxx`: **set D2R/SR of all operators.**
- `5Cxx`: **set D2R/SR of operator 1.**
- `5Dxx`: **set D2R/SR of operator 2.**
- `5Exx`: **set D2R/SR of operator 3.**
- `5Fxx`: **set D2R/SR of operator 4.**
- `60xy`: **set operator mask.**
  - enables or disables operators.
  - if `x` is `0`, `y` ranges from `0` to `F`. it is a bitfield, so `y` is the sum of the active operators' bits:
    - OP1 is +1, OP2 is +2, OP3 is +4, and OP4 is +8.
    - for example, having only OP2 and OP4 on would be 2 + 8 = 10, resulting in an `xy` value of `0A`.
  - if `x` is `1` to `4`, the effect targets that operator; `y` turns it off with a value of `0` and on with a value of `1`.
    - for example, the effect `6031` enables OP3.
- `61xx`: **set algorithm** (0 to 7).
- `62xx`: **set LFO FM depth** (0 to 7).
- `63xx`: **set LFO AM depth** (0 to 3).

## info

this chip uses the [FM (OPN)](../4-instrument/fm-opn.md), [AY-3-8910/SSG](../4-instrument/ay8910.md), [ADPCM-A](../4-instrument/adpcm-a.md) and [ADPCM-B](../4-instrument/adpcm-b.md) instrument editors.

## extended channel 2

in ExtCh mode, channel 2 is split into one column for each of its four operators. feedback and LFO levels are shared. the frequency of each operator may be controlled independently with notes and effects. this can be used for more polyphony or more complex sounds.

all four operators are still combined according to the algorithm in use. for example, algorithm 7 acts as four independent sine waves. algorithm 4 acts as two independent 2op sounds. even with algorithm 0, placing a note in any operator triggers that operator alone.

## SSG-EG

SSG-EG is short for "Software-controlled Sound Generator – Envelope Generator". it is the AY-3-8910/YM2149 envelope generator applied to each individual operator. it makes the operator's envelope play through attack, decay, sustain, and decay 2 until it reaches zero amplitude, at which time SSG triggers. according to the shape of the SSG envelope, the operator's envelope may then either loop or hold, and either of these can be set to invert the envelope (attack decreases and decay increases) when triggered.

a full guide to SSG-EG is beyond the scope of this documentation. for more information, see this [brief SSG-EG and CSM video tutorial](https://www.youtube.com/watch?v=IKOR0TUlnWU), this [detailed technical explanation](https://gendev.spritesmind.net/forum/viewtopic.php?t=386&start=106), and this [chart of tunings](https://docs.google.com/spreadsheets/d/1HGKQ08CnLGAjA1U0StJFldod3FkQ3uq86rYy1VBIuZc/).

## CSM

CSM, or "Composite Sine Mode", involves a timer matching the frequency of the note in the "CSM Timer" channel. each time it triggers, it generates key-on and key-off commands to reset the phase of all operators on channel 2 and force their envelopes to restart at the release point. this can be used to create vocal formants (speech synthesis!) or other complex effects. outside this chip's specific implementation, the technique is known as "oscillator sync".

working with CSM is beyond the scope of this documentation. for more information, see this [brief SSG-EG and CSM video tutorial](https://www.youtube.com/watch?v=IKOR0TUlnWU).

## chip config

the following options are available in the Chip Manager window:

- sets the rate at which the chip will run.
- **SSG Volume**: sets volume of SSG part.
- **FM Volume**: sets volume of FM part.
