/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import java.io.IOException;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IAttributeWriter;
import org.freeplane.core.io.IElementContentHandler;
import org.freeplane.core.io.IElementWriter;
import org.freeplane.core.io.IExtensionAttributeWriter;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TypeReference;
import org.freeplane.core.util.XmlUtils;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeWriter;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.styles.StyleString;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.features.text.ContentSyntax;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.RichTextModel;
import org.freeplane.features.text.ShortenedTextModel;
import org.freeplane.features.text.TextController;
import org.freeplane.n3.nanoxml.XMLElement;

public class NodeTextBuilder
implements IElementContentHandler,
IElementWriter,
IAttributeWriter,
IExtensionElementWriter,
IExtensionAttributeWriter {
    public static final String TEXT_ELEMENT = "text";
    public static final String XML_NODE_TEXT = "TEXT";
    public static final String XML_NODE_LOCALIZED_TEXT = "LOCALIZED_TEXT";
    public static final String XML_NODE_RICHCONTENT_TAG = "richcontent";
    public static final String XML_RICHCONTENT_TYPE_NODE = "NODE";
    public static final String XML_RICHCONTENT_TYPE_NOTE = "NOTE";
    public static final String XML_RICHCONTENT_TYPE_DETAILS = "DETAILS";
    public static final String XML_RICHCONTENT_TYPE_ATTRIBUTE = "TYPE";
    public static final String XML_RICHCONTENT_CONTENT_TYPE_ATTRIBUTE = "CONTENT-TYPE";
    public static final String XML_NODE_OBJECT = "OBJECT";
    private static final String XML_NODE_TEXT_SHORTENED = "TEXT_SHORTENED";

    @Override
    public Object createElement(Object parent, String tag, XMLElement attributes) {
        if (attributes == null) {
            return null;
        }
        String typeAttribute = attributes.getAttribute(XML_RICHCONTENT_TYPE_ATTRIBUTE, null);
        if (XML_RICHCONTENT_TYPE_NODE.equals(typeAttribute) || XML_RICHCONTENT_TYPE_DETAILS.equals(typeAttribute)) {
            return parent;
        }
        return null;
    }

    @Override
    public boolean findsClosingTagByName() {
        return true;
    }

    @Override
    public void endElement(Object parent, String tag, Object obj, XMLElement element, String content) {
        assert (tag.equals(XML_NODE_RICHCONTENT_TAG));
        String text = content != null ? content.trim() : null;
        String type = element.getAttribute(XML_RICHCONTENT_TYPE_ATTRIBUTE, null);
        NodeModel nodeModel = (NodeModel)obj;
        if (XML_RICHCONTENT_TYPE_NODE.equals(type)) {
            nodeModel.setXmlText(text);
        } else if (XML_RICHCONTENT_TYPE_DETAILS.equals(type)) {
            boolean hidden = "true".equals(element.getAttribute("HIDDEN", "false"));
            DetailModel details = new DetailModel(hidden);
            details.setXml(text);
            String contentType = element.getAttribute(XML_RICHCONTENT_CONTENT_TYPE_ATTRIBUTE, ContentSyntax.XML.prefix);
            details.setContentType(ContentSyntax.specificType(contentType));
            nodeModel.addExtension(details);
        }
    }

    private void registerAttributeHandlers(ReadManager reader) {
        reader.addAttributeHandler("node", XML_NODE_TEXT, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                Object nodeContent = node.getUserObject();
                if (nodeContent == null || nodeContent.equals("")) {
                    node.setText(value);
                }
            }
        });
        reader.addAttributeHandler("node", XML_NODE_OBJECT, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                Object newInstance = TypeReference.create(value);
                if (newInstance instanceof IFormattedObject) {
                    node.setUserObject(((IFormattedObject)newInstance).getObject());
                } else {
                    node.setUserObject(newInstance);
                }
            }
        });
        IAttributeHandler textShortenedHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                try {
                    if (Boolean.valueOf(value).booleanValue()) {
                        node.addExtension(new ShortenedTextModel());
                    }
                }
                catch (Exception e) {
                    LogUtils.warn(e);
                }
            }
        };
        reader.addAttributeHandler("node", XML_NODE_TEXT_SHORTENED, textShortenedHandler);
        reader.addAttributeHandler("stylenode", XML_NODE_TEXT_SHORTENED, textShortenedHandler);
        reader.addAttributeHandler("stylenode", XML_NODE_TEXT, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                node.setUserObject(StyleFactory.create(value));
            }
        });
        reader.addAttributeHandler("node", XML_NODE_LOCALIZED_TEXT, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                node.setUserObject(StyleFactory.create(TranslatedObject.format(value)));
            }
        });
        reader.addAttributeHandler("stylenode", XML_NODE_LOCALIZED_TEXT, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                node.setUserObject(StyleFactory.create(TranslatedObject.format(value)));
            }
        });
    }

    public void registerBy(ReadManager reader, WriteManager writeManager) {
        this.registerAttributeHandlers(reader);
        reader.addElementHandler(XML_NODE_RICHCONTENT_TAG, this);
        writeManager.addElementWriter("node", this);
        writeManager.addElementWriter("stylenode", this);
        writeManager.addAttributeWriter("node", this);
        writeManager.addAttributeWriter("stylenode", this);
    }

    @Override
    public void writeAttributes(ITreeWriter writer, Object userObject, String tag) {
        if (!NodeWriter.shouldWriteSharedContent(writer)) {
            return;
        }
        NodeModel node = (NodeModel)userObject;
        Object data = node.getUserObject();
        if (data == null) {
            return;
        }
        Class<?> dataClass = data.getClass();
        if (dataClass.equals(StyleTranslatedObject.class)) {
            writer.addAttribute(XML_NODE_LOCALIZED_TEXT, ((StyleTranslatedObject)data).getObject().toString());
            return;
        }
        if (dataClass.equals(TranslatedObject.class)) {
            writer.addAttribute(XML_NODE_LOCALIZED_TEXT, ((TranslatedObject)data).getObject().toString());
            return;
        }
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (forceFormatting) {
            String text;
            TextController textController = TextController.getController();
            Object transformed = TextController.getController().getTransformedObjectNoFormattingNoThrow(node, node, data);
            if (!transformed.equals(data)) {
                String transformedHtml = HtmlUtils.objectToHtml(transformed);
                text = HtmlUtils.toXhtml(transformedHtml);
            } else {
                text = data.toString();
            }
            if (HtmlUtils.isHtml(text)) {
                String original = data.toString();
                node.addExtension(new TransformedXMLExtension(textController.getNodeFormat(node), original, text));
            } else {
                writer.addAttribute(XML_NODE_TEXT, text.replace('\u0000', ' '));
            }
        } else {
            String text = data.toString();
            if (node.getXmlText() == null) {
                writer.addAttribute(XML_NODE_TEXT, text.replace('\u0000', ' '));
            }
            if (!(data instanceof String) && !(data instanceof StyleString)) {
                writer.addAttribute(XML_NODE_OBJECT, TypeReference.toSpec(data));
            }
        }
    }

    @Override
    public void writeContent(ITreeWriter writer, Object object, String tag) throws IOException {
        if (!NodeWriter.shouldWriteSharedContent(writer)) {
            return;
        }
        NodeModel node = (NodeModel)object;
        TransformedXMLExtension transformedXML = node.getExtension(TransformedXMLExtension.class);
        if (transformedXML != null || node.getXmlText() != null) {
            String xmlText;
            XMLElement element = new XMLElement();
            element.setName(XML_NODE_RICHCONTENT_TAG);
            element.setAttribute(XML_RICHCONTENT_TYPE_ATTRIBUTE, XML_RICHCONTENT_TYPE_NODE);
            if (transformedXML != null) {
                xmlText = transformedXML.xhtml;
                if (transformedXML.originaText != null) {
                    element.setAttribute("FORMAT", transformedXML.contentType);
                    XMLElement textElement = element.createElement(TEXT_ELEMENT);
                    textElement.setContent(transformedXML.originaText);
                    element.addChild(textElement);
                }
                node.removeExtension(transformedXML);
            } else {
                xmlText = node.getXmlText();
            }
            String content = xmlText.replace('\u0000', ' ');
            writer.addElement((Object)('\n' + content + '\n'), element);
        }
    }

    @Override
    public void writeContent(ITreeWriter writer, Object node, IExtension extension) throws IOException {
        DetailModel details = (DetailModel)extension;
        XMLElement element = new XMLElement();
        element.setAttribute(XML_RICHCONTENT_TYPE_ATTRIBUTE, XML_RICHCONTENT_TYPE_DETAILS);
        if (details.isHidden()) {
            element.setAttribute("HIDDEN", "true");
        }
        NodeTextBuilder.writeRichContent(writer, node, details, element);
    }

    public static void writeRichContent(ITreeWriter writer, Object node, RichTextModel richContent, XMLElement element) throws IOException {
        Object transformed;
        String data;
        ContentSyntax contentSyntax;
        element.setName(XML_NODE_RICHCONTENT_TAG);
        String xmlContent = richContent.getXml();
        String contentType = richContent.getContentType();
        ContentSyntax contentSyntax2 = contentSyntax = xmlContent == null || XmlUtils.startsWithElement(xmlContent, TEXT_ELEMENT) ? ContentSyntax.PLAIN : ContentSyntax.XML;
        if (contentType != null) {
            element.setAttribute(XML_RICHCONTENT_CONTENT_TYPE_ATTRIBUTE, contentSyntax.with(contentType));
        }
        if (xmlContent == null) {
            if (contentType != null) {
                writer.addElement(null, element);
            }
            return;
        }
        String transformedXhtml = "";
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (forceFormatting && (data = richContent.getText()) != null && !(transformed = TextController.getController().getTransformedObjectNoFormattingNoThrow((NodeModel)node, richContent, data)).equals(data)) {
            String transformedHtml = HtmlUtils.objectToHtml(transformed);
            transformedXhtml = HtmlUtils.toXhtml(transformedHtml);
        }
        String combinedContent = contentSyntax == ContentSyntax.PLAIN && !transformedXhtml.isEmpty() ? xmlContent + "\n" + transformedXhtml : xmlContent;
        writer.addElement((Object)combinedContent, element);
    }

    @Override
    public void writeAttributes(ITreeWriter writer, Object userObject, IExtension extension) {
        writer.addAttribute(XML_NODE_TEXT_SHORTENED, Boolean.TRUE.toString());
    }

    private static class TransformedXMLExtension
    implements IExtension {
        private String contentType;
        private String originaText;
        private String xhtml;

        public TransformedXMLExtension(String contentType, String original, String html) {
            this.contentType = contentType;
            this.originaText = original.equals(html) ? null : HtmlUtils.htmlToPlain(original);
            this.xhtml = HtmlUtils.toXhtml(html);
        }
    }
}

